# バッチ設計書 38-upload-nlsmetadata.ts

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるNLS（National Language Support）メタデータアップロードバッチ「upload-nlsmetadata.ts」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのローカライゼーション（多言語化）に必要なNLSメタデータをAzure Blob Storageにアップロードします。言語パック作成者やTransifex等の翻訳サービスが使用するメタデータファイルを生成・配信します。

**業務上の目的・背景**：VSCodeは40以上の言語に対応しており、ローカライゼーションは言語パック拡張機能によって提供されます。言語パック作成者は、VSCodeコアおよび組み込み拡張機能の翻訳対象文字列（キーとメッセージ）を知る必要があります。このバッチでは、ビルド時に生成されたNLSメタデータを統合し、言語パック作成者がアクセスできる場所に公開します。これにより、コミュニティによる翻訳作業と言語パックの作成が効率化されます。

**バッチの実行タイミング**：Azure Pipelinesによる製品ビルドパイプラインの一部として、ビルド完了後に自動実行されます。

**主要な処理内容**：
1. VSCodeコアのNLSキーとメッセージの収集（nls.keys.json、nls.messages.json）
2. 拡張機能のNLSメタデータ収集（nls.metadata.json、nls.metadata.header.json、package.nls.json）
3. 統合JSONファイルの生成（combined.nls.metadata.json）
4. gzip圧縮とAzure Blob Storageへのアップロード
5. Azure DevOpsアーティファクトとしての登録

**前後の処理との関連**：事前にproduct-buildパイプラインによるビルドが完了し、NLSメタデータが生成されている必要があります。upload-sourcemaps.tsと並行して実行されます。

**影響範囲**：Azure Blob Storage上のNLSメタデータファイル。言語パック拡張機能の作成、Transifexとの連携に影響します。

## バッチ種別

ビルドスクリプト / デプロイ / ローカライゼーション

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドごと（製品ビルド時） |
| 実行時刻 | ビルドパイプライン依存 |
| 実行曜日 | ビルドパイプライン依存 |
| 実行日 | ビルドパイプライン依存 |
| トリガー | Azure Pipelines（product-build完了後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | compileタスクが完了していること |
| NLSファイル | out-build/nls.keys.json、nls.messages.jsonが存在すること |
| 拡張機能ビルド | 拡張機能のNLSメタデータが.build/extensions配下に存在すること |
| 環境変数 | BUILD_SOURCEVERSION（コミットハッシュ）が設定されていること |
| Azure認証 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENが設定されていること |

### 実行可否判定

必要な環境変数が全て設定され、NLSメタデータファイルが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取りません。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| out-build/nls.keys.json | JSON | VSCodeコアの翻訳キー |
| out-build/nls.messages.json | JSON | VSCodeコアの翻訳メッセージ |
| out-build/nls.messages.js | JavaScript | ランタイム用NLSメッセージ |
| .build/extensions/**/nls.metadata.json | JSON | 拡張機能のNLSメタデータ |
| .build/extensions/**/nls.metadata.header.json | JSON | 拡張機能のNLSヘッダー |
| .build/extensions/**/package.nls.json | JSON | 拡張機能のpackage.json翻訳 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure Blob Storage | gzip圧縮JSON | 統合NLSメタデータ |
| Azure DevOps Artifact | gzip圧縮ファイル | ビルドアーティファクト |
| ./nlsMetadata/ | gzip圧縮ファイル | ローカル出力 |
| 標準出力 | テキスト | アップロード進捗ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | combined.nls.metadata.json（gzip圧縮） |
| コンテナ名 | $web |
| プレフィックス | nlsmetadata/{commit}/ |
| 文字コード | UTF-8 |
| Content-Encoding | gzip |
| Cache-Control | max-age=31536000, public |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ BUILD_SOURCEVERSION（コミットハッシュ）
   └─ Azure認証情報
2. 認証情報作成
   └─ ClientAssertionCredentialの初期化
3. VSCodeコアメタデータ収集
   └─ nls.keys.jsonとnls.messages.jsonの読み込み
   └─ vscode.json形式にマージ
4. 拡張機能メタデータ収集
   └─ 各拡張機能からnls.metadata.json読み込み
   └─ nls.metadata.header.json読み込み
   └─ package.nls.json読み込み
   └─ publisher.name形式のキーで統合
5. メタデータ統合
   └─ combined.nls.metadata.json生成
6. gzip圧縮
   └─ 全出力ファイルを圧縮
7. ローカル出力
   └─ ./nlsMetadata/に書き出し
8. アーティファクト登録
   └─ ##vso[artifact.upload]コマンド出力
9. Azure Blobアップロード
   └─ nlsmetadata/{commit}/配下
10. nls.messages.jsアップロード
    └─ ランタイム用ファイル
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数取得]
    B --> C[Azure認証]
    C --> D[VSCodeコアNLS収集]
    D --> E[nls.keys.json読み込み]
    E --> F[nls.messages.json読み込み]
    F --> G[vscode.json生成]
    G --> H[拡張機能NLS収集]
    H --> I[nls.metadata.json処理]
    I --> J[package.nls.json処理]
    J --> K[publisher.nameキーで統合]
    K --> L[combined.nls.metadata.json生成]
    L --> M[gzip圧縮]
    M --> N[ローカル出力]
    N --> O[Azure DevOpsアーティファクト登録]
    O --> P[Azure Blobアップロード]
    P --> Q{エラー発生?}
    Q -->|Yes| R[exit 1]
    Q -->|No| S[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 認証エラー | Azure認証情報が無効 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENを確認 |
| 1 | アップロードエラー | Azure Blob Storageへの接続失敗 | ネットワーク設定、ストレージアカウントを確認 |
| 1 | ファイル読み込みエラー | NLSメタデータファイルが存在しない | ビルドが正常に完了しているか確認 |
| 1 | JSON解析エラー | NLSファイルの形式が不正 | ビルドプロセスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | gulp-azure-storageの内部リトライ |
| リトライ間隔 | ライブラリ依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

### 障害時対応

1. Azure認証情報を確認
2. ビルド成果物の存在を確認（nls.keys.json、nls.messages.json）
3. 拡張機能のNLSメタデータを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルアップロード） |
| コミットタイミング | 各ファイルごとに完了 |
| ロールバック条件 | N/A（冪等性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十ファイル |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 1GB程度 |

## 排他制御

コミットハッシュをプレフィックスとして使用するため、異なるビルド間での競合は発生しません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ファイルアップロード時 | "Uploading {パス}" |
| アーティファクトログ | アーティファクト登録時 | ##vso[artifact.upload]形式 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| アップロード失敗 | 0件 | Azure Pipelinesパイプラインステータス |
| 実行時間 | 15分 | パイプラインタイムアウト |

## 備考

- NlsMetadataインターフェースは以下の構造を持ちます：
  - keys: モジュールごとの翻訳キー配列
  - messages: モジュールごとの翻訳メッセージ配列
  - bundles: バンドルごとのモジュールリスト
- 拡張機能のキーは`publisher.name`形式で生成されます（例：`vscode.typescript-language-features`）
- package.nls.jsonはpackage.jsonの翻訳を含み、特別な"package"キーで格納されます
- Content-Encodingヘッダーにgzipを設定し、Cache-Controlには1年間のキャッシュを設定します
- `##vso[artifact.upload]`コマンドはAzure DevOpsのビルドアーティファクト機能を使用します
- nls.messages.jsはブラウザでのランタイム使用のためにもアップロードされます
