# バッチ設計書 39-upload-cdn.ts

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるCDN（Content Delivery Network）アップロードバッチ「upload-cdn.ts」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのWeb版（vscode.dev）向け静的アセットをAzure Blob Storage（CDN配信用）にアップロードします。JavaScript、CSS、フォント、画像などの静的ファイルを圧縮可能なものはgzip圧縮してアップロードし、CDN経由での高速配信を可能にします。

**業務上の目的・背景**：vscode.devはブラウザで動作するVSCodeであり、全てのリソースをCDN経由で配信します。ユーザーのブラウザに迅速にアセットを配信するため、Azure CDN（Azure Front Door）を使用しています。このバッチでは、ビルド済みのWeb版アセットをCDNバックエンドのBlobストレージにアップロードし、適切なContent-EncodingとCache-Controlヘッダーを設定します。これにより、vscode.devの高速な初期ロードと効率的なキャッシュ利用が実現されます。

**バッチの実行タイミング**：Azure Pipelinesによる製品ビルドパイプライン（product-build-web.yml）の一部として、Web版ビルド完了後に自動実行されます。

**主要な処理内容**：
1. vscode-webディレクトリから全アセットの収集
2. MIMEタイプに基づく圧縮対象の判定
3. 圧縮対象ファイルのgzip圧縮
4. Azure Blob Storageへのアップロード（圧縮/非圧縮を分離）
5. アップロードしたファイルのリスト（files.txt）の生成・アップロード

**前後の処理との関連**：事前にproduct-build-web.ymlによるWeb版ビルドが完了し、vscode-webディレクトリにアセットが生成されている必要があります。

**影響範囲**：Azure Blob Storage上のWeb版静的アセット。vscode.devの動作に直接影響します。

## バッチ種別

ビルドスクリプト / デプロイ / CDN配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドごと（Web版ビルド時） |
| 実行時刻 | ビルドパイプライン依存 |
| 実行曜日 | ビルドパイプライン依存 |
| 実行日 | ビルドパイプライン依存 |
| トリガー | Azure Pipelines（product-build-web完了後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Web版ビルド完了 | ../vscode-webディレクトリにアセットが存在すること |
| 環境変数 | BUILD_SOURCEVERSION（コミットハッシュ）が設定されていること |
| 環境変数 | VSCODE_QUALITY（品質レベル：stable/insider等）が設定されていること |
| Azure認証 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENが設定されていること |
| Azureストレージ | AZURE_STORAGE_ACCOUNTが設定されていること |

### 実行可否判定

必要な環境変数が全て設定され、../vscode-webディレクトリにアセットが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取りません。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ../vscode-web/** | Various | Web版静的アセット（JS、CSS、画像、フォント等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure Blob Storage | 各種ファイル | 静的アセット（圧縮/非圧縮） |
| Azure Blob Storage | テキスト | files.txt（ファイルリスト） |
| 標準出力 | テキスト | アップロード進捗ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| コンテナ名 | $web |
| プレフィックス | {quality}/{commit}/ |
| 文字コード | UTF-8 |
| Content-Encoding | gzip（対象MIMEタイプのみ） |
| Cache-Control | max-age=31536000, public |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ BUILD_SOURCEVERSION（コミットハッシュ）
   └─ VSCODE_QUALITY（品質レベル）
   └─ Azure認証情報
2. 認証情報作成
   └─ ClientAssertionCredentialの初期化
3. アセット収集
   └─ ../vscode-web配下の全ファイル収集
   └─ ディレクトリの除外
4. MIMEタイプ判定
   └─ 各ファイルのMIMEタイプを判定
   └─ MimeTypesToCompressセットで圧縮対象を判定
5. 圧縮対象アップロード
   └─ gzip圧縮
   └─ Content-Encoding: gzipでアップロード
6. 非圧縮対象アップロード
   └─ そのままアップロード
7. ファイルリスト生成
   └─ アップロードしたファイルのリスト作成
   └─ files.txtとしてアップロード
8. 完了処理
   └─ エラー時はprocess.exit(1)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数取得]
    B --> C[Azure認証]
    C --> D[vscode-webアセット収集]
    D --> E[ディレクトリ除外]
    E --> F{MIMEタイプ判定}
    F -->|圧縮対象| G[gzip圧縮]
    F -->|非圧縮対象| H[そのまま]
    G --> I[Content-Encoding: gzipでアップロード]
    H --> J[アップロード]
    I --> K[ファイルリスト収集]
    J --> K
    K --> L[files.txt生成]
    L --> M[files.txtアップロード]
    M --> N{エラー発生?}
    N -->|Yes| O[exit 1]
    N -->|No| P[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 認証エラー | Azure認証情報が無効 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENを確認 |
| 1 | アップロードエラー | Azure Blob Storageへの接続失敗 | ネットワーク設定、ストレージアカウントを確認 |
| 1 | ファイル読み込みエラー | vscode-webディレクトリが存在しない | Web版ビルドが正常に完了しているか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | gulp-azure-storageの内部リトライ |
| リトライ間隔 | ライブラリ依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

### 障害時対応

1. Azure認証情報を確認
2. ../vscode-webディレクトリの存在を確認
3. VSCODE_QUALITYが正しく設定されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルアップロード） |
| コミットタイミング | 各ファイルごとに完了 |
| ロールバック条件 | N/A（冪等性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千ファイル |
| 目標処理時間 | 15分以内 |
| メモリ使用量上限 | 2GB程度 |

## 排他制御

{quality}/{commit}/形式のプレフィックスを使用するため、異なるビルド間での競合は発生しません。同一コミットの再実行は上書きとなります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Uploading files to CDN..." |
| 進捗ログ | 各ファイルアップロード時 | "Uploaded: {相対パス}" |
| 完了ログ | files.txt生成時 | "Uploading: files.txt ({件数} files)" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| アップロード失敗 | 0件 | Azure Pipelinesパイプラインステータス |
| 実行時間 | 30分 | パイプラインタイムアウト |

## 備考

- MimeTypesToCompressセットには以下のようなMIMEタイプが含まれます：
  - text系: text/html, text/css, text/javascript, text/plain, text/xml等
  - application系: application/javascript, application/json, application/xml等
  - font系: font/ttf, font/otf, font/opentype等
  - image/svg+xml
- カスタムMIMEタイプの定義：
  - application/typescript: .ts ファイル
  - application/json: .code-snippets ファイル
- アップロード先のパスは `{quality}/{commit}/` 形式で、qualityはstable、insider等のリリースチャネルを示します
- files.txtはアップロードされた全ファイルのリストを含み、デプロイ検証やデバッグに使用されます
- Cache-Controlは1年間のキャッシュを設定し、ファイル名にハッシュが含まれる前提でキャッシュ無効化を行います
- 圧縮対象と非圧縮対象は並列でアップロードされ、効率的な処理を実現しています
