# バッチ設計書 4-product-release

## 概要

本ドキュメントは、Visual Studio Codeのリリースビルド公開処理「product-release」の設計仕様を定義するものです。Publishステージ完了後、承認を経てリリースビルドを公開する処理を担当します。

### 本バッチの処理概要

本バッチは、product-buildパイプラインのReleaseステージとして実行され、ビルド成果物を正式にリリースとしてマークし、公開サーバーへ反映します。releaseBuild.tsスクリプトを実行してリリース処理を完了させます。

**業務上の目的・背景**：VSCodeのリリースプロセスでは、Insiderビルドや安定版ビルドをユーザーに公開する前に、品質チェックと承認プロセスを経る必要があります。本バッチは、Publishステージで公開準備が整った成果物を、正式なリリースとして公開するための最終処理を行います。これにより、リリースの品質管理とトレーサビリティを確保しています。

**バッチの実行タイミング**：product-buildパイプラインでVSCODE_RELEASE=trueが設定され、かつApproveReleaseステージで承認された後に実行されます。手動でリリースパラメータを指定してパイプラインを実行した場合のみ動作します。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. Node.jsセットアップ
3. Azure認証シークレットの取得
4. ビルド依存関係のインストール
5. 公開認証トークンの取得
6. releaseBuild.tsによるリリース処理実行

**前後の処理との関連**：本バッチは、Publishステージの完了とApproveReleaseステージでの承認を前提条件としています。Publishステージで成果物がbuilds.code.visualstudio.comにアップロードされた状態で、本バッチがリリースフラグを設定します。

**影響範囲**：builds.code.visualstudio.com（リリースステータス更新）、Azure Cosmos DB（ビルドメタデータ更新）、VSCodeのアップデートチャンネルに影響します。

## バッチ種別

CI/CDパイプライン（リリース処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 手動（VSCODE_RELEASE=true指定時） |
| 実行時刻 | 手動トリガー |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | ApproveRelease承認後 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| VSCODE_RELEASE | true であること（パラメータ指定） |
| VSCODE_PRIVATE_BUILD | false であること（公式リポジトリ） |
| Publishステージ | 完了していること |
| ApproveReleaseステージ | 承認されていること |
| ビルドエージェント | 1es-ubuntu-22.04-x64 プールが利用可能 |

### 実行可否判定

```
条件: and(
  parameters.VSCODE_RELEASE,
  eq(variables['VSCODE_PRIVATE_BUILD'], false)
)
```

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_RELEASE | boolean | Yes | false | リリースを実行するかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure Service Principal | Token | Azure認証用IDトークン |
| Publishステージの成果物 | 公開済みビルド | リリース対象のビルド情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure Cosmos DB | JSON | ビルドメタデータ（released: true） |
| builds.code.visualstudio.com | ステータス | リリース公開状態 |

### 出力ファイル仕様

本バッチではファイル出力は行いません。全ての出力はAPIを通じてデータベースおよび公開サーバーに反映されます。

## 処理フロー

### 処理シーケンス

```
1. ソースコードチェックアウト
   └─ common/checkout.ymlテンプレート使用
2. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
3. Azureシークレット取得
   └─ AzureCLI@2でサービスプリンシパル情報取得
   └─ AZURE_TENANT_ID, AZURE_CLIENT_ID, AZURE_ID_TOKEN
4. ビルド依存関係インストール
   └─ build/ディレクトリでnpm ci
5. 公開認証トークン取得
   └─ getPublishAuthTokens.ts実行
6. リリースビルド実行
   └─ releaseBuild.ts $(VSCODE_RELEASE)
```

### フローチャート

```mermaid
flowchart TD
    A[Releaseステージ開始] --> B{Publish完了?}
    B -->|No| C[待機]
    C --> B
    B -->|Yes| D{承認済み?}
    D -->|No| E[待機]
    E --> D
    D -->|Yes| F[チェックアウト]
    F --> G[Node.jsセットアップ]
    G --> H[Azureシークレット取得]
    H --> I[npm ci]
    I --> J[認証トークン取得]
    J --> K[releaseBuild.ts実行]
    K --> L{成功?}
    L -->|Yes| M[完了]
    L -->|No| N[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| releaseBuild | Azure Cosmos DB | UPDATE | ビルドのreleased状態を更新 |

### テーブル別操作詳細

#### Azure Cosmos DB (vscode.documents.azure.com)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | released | true | VSCODE_RELEASE=true時 |
| UPDATE | releaseTimestamp | 現在時刻 | リリース日時記録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AUTH_FAILED | 認証エラー | Azure認証失敗 | サービスプリンシパル設定確認 |
| TOKEN_FAILED | トークンエラー | 公開認証トークン取得失敗 | Azure接続確認 |
| RELEASE_FAILED | リリースエラー | releaseBuild.ts実行失敗 | ログ確認、Publishステージ確認 |
| BUILD_NOT_FOUND | ビルドエラー | リリース対象ビルドが見つからない | Publishステージの完了確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | - |
| リトライ対象エラー | 手動で再実行 |

### 障害時対応

1. 認証エラーの場合、Azure Service Principalの設定を確認
2. リリース失敗の場合、releaseBuild.tsの出力ログを確認
3. 必要に応じて手動でステージを再実行
4. Cosmos DBの直接更新が必要な場合は運用チームに連絡

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | リリース処理全体 |
| コミットタイミング | releaseBuild.ts正常完了時 |
| ロールバック条件 | リリース処理失敗時は状態変更なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リリース/実行 |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

- 承認プロセス（ApproveRelease）により、意図しないリリースを防止
- 同一ビルドIDに対する重複リリースはreleaseBuild.tsで制御
- VSCODE_PRIVATE_BUILD=trueの場合は実行されない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、VSCODE_RELEASEパラメータ |
| 認証ログ | 認証処理時 | 認証成功/失敗 |
| リリースログ | リリース処理時 | リリース対象バージョン、処理結果 |
| 完了ログ | ジョブ完了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リリース失敗 | 1回 | Azure DevOps通知、リリースチーム |
| 処理時間 | 10分超過 | ビルドログ |

## 備考

- Linuxエージェント（1es-ubuntu-22.04-x64）で実行
- VSCODE_PRIVATE_BUILD=false（公式リポジトリ）でのみ実行可能
- ApproveReleaseステージでのピアレビュー承認が必須（VSCodePeerApproval変数グループ使用）
- releaseBuild.tsはパラメータとしてVSCODE_RELEASEの値を受け取る
- PUBLISH_AUTH_TOKENSは機密情報として扱われ、ログには出力されない
