# バッチ設計書 40-codesign.ts

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるコード署名処理バッチ「codesign.ts」の設計仕様を記載します。各プラットフォーム（Windows、macOS、Linux）向けに個別のスクリプトが存在します。

### 本バッチの処理概要

このバッチは、VSCodeのビルド成果物（実行ファイル、共有ライブラリ、インストーラー等）に対してデジタル署名を適用します。Microsoftの ESRP（Enterprise Security Release Pipeline）を使用して、プラットフォーム固有の署名処理を実行します。

**業務上の目的・背景**：ソフトウェアにデジタル署名を適用することは、セキュリティと信頼性の観点から重要です。署名されたソフトウェアは、発行元の身元を証明し、コードが改ざんされていないことを保証します。Windows ではSmartScreenフィルター、macOSではGatekeeperが未署名ソフトウェアをブロックするため、署名は配布に必須です。このバッチでは、ESRPを通じてMicrosoftの証明書でコード署名を行い、ユーザーが安全にVSCodeをインストール・実行できるようにします。

**バッチの実行タイミング**：Azure Pipelinesによる各プラットフォームのビルドパイプライン（product-build-win32.yml、product-build-darwin.yml、product-build-linux.yml）の一部として、ビルド完了後に自動実行されます。

**主要な処理内容**：
1. **Windows**: DLL/EXE/Nodeファイル署名、PowerShellスクリプト署名、APPXパッケージ署名、セットアップ作成・署名
2. **macOS**: アプリケーションバンドル署名、Apple公証（Notarization）
3. **Linux**: DEBパッケージ署名（PGP）、RPMパッケージ署名（PGP）

**前後の処理との関連**：事前に各プラットフォームのビルドタスク（compile、package）が完了している必要があります。署名後はアーティファクトのアップロードが行われます。

**影響範囲**：各プラットフォームの配布用バイナリ、インストーラー、パッケージファイル。

## バッチ種別

ビルドスクリプト / セキュリティ / コード署名

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドごと（各プラットフォームビルド時） |
| 実行時刻 | ビルドパイプライン依存 |
| 実行曜日 | ビルドパイプライン依存 |
| 実行日 | ビルドパイプライン依存 |
| トリガー | Azure Pipelines（各プラットフォームビルド完了後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | 各プラットフォームのビルドタスクが完了していること |
| ESRP CLI | EsrpCliDllPathでESRP CLIへのパスが設定されていること |
| 環境変数 | VSCODE_ARCH（アーキテクチャ）が設定されていること |
| 環境変数 | CodeSigningFolderPath（署名対象フォルダ、Windows）が設定されていること |
| 環境変数 | PIPELINE_WORKSPACE（ワークスペース、macOS）が設定されていること |
| ビルドフラグ | BUILT_CLIENT、BUILT_SERVER、BUILT_WEB（何がビルドされたか） |

### 実行可否判定

ESRPCliDllPathが設定され、署名対象のファイルが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ（共通）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | 環境変数 | Yes | - | ターゲットアーキテクチャ（x64、arm64等） |
| EsrpCliDllPath | 環境変数 | Yes | - | ESRP CLIへのパス |

### 入力パラメータ（Windows固有）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CodeSigningFolderPath | 環境変数 | Yes | - | 署名対象フォルダ |
| BUILT_CLIENT | 環境変数 | No | - | クライアントがビルドされたか |
| BUILT_SERVER | 環境変数 | No | - | サーバーがビルドされたか |
| BUILT_WEB | 環境変数 | No | - | Web版がビルドされたか |
| VSCODE_QUALITY | 環境変数 | No | - | 品質レベル |

### 入力パラメータ（macOS固有）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PIPELINE_WORKSPACE | 環境変数 | Yes | - | パイプラインワークスペース |

### 入力データソース

| プラットフォーム | データソース | 形式 | 説明 |
|-----------------|-------------|------|------|
| Windows | *.dll, *.exe, *.node | バイナリ | 実行ファイル・共有ライブラリ |
| Windows | *.ps1 | PowerShell | PowerShellスクリプト |
| Windows | *.appx | パッケージ | コンテキストメニュー拡張 |
| macOS | VSCode-darwin-{arch}.zip | アーカイブ | macOSアプリケーション |
| Linux | *.deb | パッケージ | Debianパッケージ |
| Linux | *.rpm | パッケージ | RPMパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 署名済みバイナリ | 各種 | デジタル署名が適用されたファイル |
| パッケージ | ZIP/インストーラー | 署名済みのアーカイブ・インストーラー |
| 標準出力 | テキスト | 署名処理の進捗ログ |

### 出力ファイル仕様（Windows）

| 項目 | 内容 |
|-----|------|
| クライアントアーカイブ | .build/win32-{arch}/VSCode-win32-{arch}.zip |
| サーバーアーカイブ | .build/win32-{arch}/vscode-server-win32-{arch}.zip |
| Webサーバーアーカイブ | .build/win32-{arch}/vscode-server-win32-{arch}-web.zip |

## 処理フロー

### 処理シーケンス（Windows）

```
1. 環境変数取得
   └─ VSCODE_ARCH、EsrpCliDllPath、CodeSigningFolderPath
2. 署名タスク起動（並列）
   └─ タスク1: DLL/EXE/Nodeファイル署名
   └─ タスク2: PowerShellスクリプト署名
   └─ タスク3: APPXパッケージ署名（exploration以外）
3. 署名完了待機
   └─ 各タスクの完了を順次待機
4. ビルドアーティファクトディレクトリ作成
5. クライアントパッケージ作成（BUILT_CLIENT時）
   └─ 7z.exeでZIPアーカイブ作成
6. サーバーパッケージ作成（BUILT_SERVER時）
   └─ 7z.exeでZIPアーカイブ作成
7. Webサーバーパッケージ作成（BUILT_WEB時）
   └─ 7z.exeでZIPアーカイブ作成
8. セットアップ作成・署名（BUILT_CLIENT時）
   └─ Gulpタスクでセットアップ作成
```

### 処理シーケンス（macOS）

```
1. 環境変数取得
   └─ VSCODE_ARCH、EsrpCliDllPath、PIPELINE_WORKSPACE
2. コード署名
   └─ spawnCodesignProcess('sign-darwin')
   └─ VSCode-darwin-{arch}.zipに署名
3. 公証（Notarization）
   └─ spawnCodesignProcess('notarize-darwin')
   └─ Appleの公証サービスに提出
```

### 処理シーケンス（Linux）

```
1. 環境変数取得
   └─ EsrpCliDllPath
2. 署名タスク起動（並列）
   └─ タスク1: DEBパッケージ署名（PGP）
   └─ タスク2: RPMパッケージ署名（PGP）
3. 署名完了待機
   └─ 各タスクの完了を順次待機
```

### フローチャート（Windows）

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数取得]
    B --> C[署名タスク並列起動]
    C --> D[DLL/EXE/Node署名]
    C --> E[PowerShell署名]
    C --> F{exploration?}
    F -->|No| G[APPX署名]
    F -->|Yes| H[スキップ]
    D --> I[署名完了待機]
    E --> I
    G --> I
    H --> I
    I --> J[ビルドディレクトリ作成]
    J --> K{BUILT_CLIENT?}
    K -->|Yes| L[クライアントZIP作成]
    K -->|No| M[スキップ]
    L --> N{BUILT_SERVER?}
    M --> N
    N -->|Yes| O[サーバーZIP作成]
    N -->|No| P[スキップ]
    O --> Q{BUILT_WEB?}
    P --> Q
    Q -->|Yes| R[WebサーバーZIP作成]
    Q -->|No| S[スキップ]
    R --> T{BUILT_CLIENT?}
    S --> T
    T -->|Yes| U[セットアップ作成・署名]
    T -->|No| V[完了]
    U --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 署名エラー | ESRPサービスへの接続失敗 | ESRP認証情報を確認 |
| 1 | 公証エラー（macOS） | Apple公証サービスエラー | Apple Developer資格情報を確認 |
| 1 | ファイル不在 | 署名対象ファイルが存在しない | ビルドが正常に完了しているか確認 |
| 1 | アーカイブエラー | 7z.exeの実行失敗 | アーカイブツールのインストールを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ESRPサービス内部でのリトライ |
| リトライ間隔 | サービス依存 |
| リトライ対象エラー | 一時的なサービスエラー |

### 障害時対応

1. ESRP認証情報と接続設定を確認
2. 署名対象ファイルの存在を確認
3. パイプラインログでESRPからのエラーメッセージを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各署名タスク単位 |
| コミットタイミング | 各ファイルの署名完了時 |
| ロールバック条件 | 署名失敗時は元のファイルを保持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル（Windows）/ 1ファイル（macOS）/ 数ファイル（Linux） |
| 目標処理時間 | 30分以内（macOS公証を含む） |
| メモリ使用量上限 | 2GB程度 |

## 排他制御

署名処理は並列実行されますが、同一ファイルへの同時署名は発生しません。異なる署名タイプ（Authenticode、PGP等）は異なるファイルセットを対象とします。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バナーログ | 各処理フェーズ開始時 | printBanner関数による区切り |
| 進捗ログ | 各処理実行時 | 処理名と所要時間 |
| 完了ログ | 各処理完了時 | "{処理名} completed successfully. Duration: {ms} ms" |
| エラーログ | エラー発生時 | "ERROR: {エラーメッセージ}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 署名失敗 | 0件 | Azure Pipelinesパイプラインステータス |
| 実行時間 | 60分 | パイプラインタイムアウト |

## 備考

- spawnCodesignProcess関数は`build/azure-pipelines/common/sign.ts`を呼び出してESRP CLIを実行します
- 署名タイプ：
  - `sign-windows`: Windows Authenticode署名（DLL、EXE、Node）
  - `sign-windows-appx`: Windows Authenticode署名（PowerShell、APPX）
  - `sign-darwin`: macOSコード署名
  - `notarize-darwin`: Apple公証
  - `sign-pgp`: PGP署名（Linux）
- printBanner関数は視覚的な区切りを出力し、処理フェーズの識別を容易にします
- streamProcessOutputAndCheckResult関数はプロセス出力をストリーミングし、結果を検証します
- Windows版では`exploration`品質（実験版）の場合、APPXパッケージの署名をスキップします
- macOSの公証（Notarization）はAppleのセキュリティ要件を満たすために必要で、署名後に別途実行されます
- CodeSignSummary*.mdファイルは署名レポートであり、アーカイブからは除外されます
