# バッチ設計書 41-product-build-win32.yml

## 概要

本ドキュメントは、VS Code Windows版（x64/arm64）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、Windows向けクライアント、サーバー、Webサーバーの各種配布形式を生成します。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code Windows版をエンドユーザーに配布するためには、クライアントアプリケーション、リモート開発サーバー、Webサーバーの各種ビルド成果物が必要です。本バッチは、ソースコードからコンパイル済みバイナリを取得し、ESRPコード署名を施した上で、インストーラー（system-setup/user-setup）、ZIPアーカイブ、サーバーアーカイブなどの配布形式を生成します。これにより、Windows環境でのVS Code利用を可能にし、セキュリティ要件を満たした正規ビルドを提供します。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、mainブランチへのマージ時、release/*ブランチ更新時、または手動トリガー時に実行されます。CIビルドモードでも実行可能です。

**主要な処理内容**：
1. コンパイル成果物（Compilation artifact）のダウンロードと展開
2. node_modulesのキャッシュ復元または依存関係インストール
3. ディストリビューション品質ミックスインの適用
4. 組み込み拡張機能のインストール
5. クライアントビルド（vscode-win32-$(VSCODE_ARCH)-min-ci）
6. サーバービルド（vscode-reh-win32-$(VSCODE_ARCH)-min-ci）
7. Webサーバービルド（vscode-reh-web-win32-$(VSCODE_ARCH)-min-ci）
8. CLIのダウンロードと統合
9. ESRPコード署名（dll, exe, node）
10. 配布アーカイブの生成（Setup, Archive, Server）

**前後の処理との関連**：Compilationジョブで生成されたコンパイル成果物をダウンロードして使用します。CLIビルド（product-build-win32-cli）の成果物も統合します。後続でCDN・リリースパイプラインにアップロードされます。

**影響範囲**：Windows版VS Codeの全配布形式、リモート開発機能、vscode.dev対応サーバーに影響します。

## バッチ種別

プラットフォームビルド / ソフトウェアパッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Compilation artifact | コンパイル成果物が事前にパイプラインで生成されていること |
| Azure Key Vault | github-distro-mixin-passwordシークレットが取得可能であること |
| ESRP接続 | ESRPコード署名サービスへの接続が有効であること |
| Node.js | .nvmrcで指定されたバージョンが利用可能であること |

### 実行可否判定

パラメータVSCODE_CIBUILDがtrueの場合はCIビルドモードとなり、コード署名やインストーラー生成がスキップされます。テストパラメータ（VSCODE_RUN_*_TESTS）に応じてテストフェーズが実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64） |
| VSCODE_CIBUILD | boolean | Yes | - | CIビルドモードフラグ |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider/exploration） |
| VSCODE_RUN_ELECTRON_TESTS | boolean | No | false | Electronテスト実行フラグ |
| VSCODE_RUN_BROWSER_TESTS | boolean | No | false | ブラウザテスト実行フラグ |
| VSCODE_RUN_REMOTE_TESTS | boolean | No | false | リモートテスト実行フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilation artifact | tar.gz | コンパイル済みTypeScriptコード |
| unsigned_vscode_cli_win32_$(VSCODE_ARCH)_cli | zip | 署名前CLIバイナリ |
| Azure Key Vault | シークレット | github-distro-mixin-password |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_client_win32_$(VSCODE_ARCH)_setup | exe | システムインストーラー |
| vscode_client_win32_$(VSCODE_ARCH)_user-setup | exe | ユーザーインストーラー |
| vscode_client_win32_$(VSCODE_ARCH)_archive | zip | ポータブルアーカイブ |
| vscode_server_win32_$(VSCODE_ARCH)_archive | zip | リモート開発サーバー |
| vscode_web_win32_$(VSCODE_ARCH)_archive | zip | Webサーバー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VSCodeSetup-$(VSCODE_ARCH)-$(VSCODE_VERSION).exe / VSCodeUserSetup-$(VSCODE_ARCH)-$(VSCODE_VERSION).exe / VSCode-win32-$(VSCODE_ARCH)-$(VSCODE_VERSION).zip |
| 出力先 | $(Build.ArtifactStagingDirectory)/out/{system-setup,user-setup,archive,server,web} |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js、Python環境の準備
3. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
4. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password
5. コンパイル成果物ダウンロード
   └─ Compilation artifactの展開
6. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
7. node_modulesキャッシュ復元/インストール
   └─ 依存関係の準備
8. ディストリビューションミックスイン
   └─ npm modules、quality設定の適用
9. 組み込み拡張機能インストール
   └─ built-in extensionsの配置
10. グループポリシー定義生成（非CI）
    └─ Windows GPO用ADMX/ADMLファイル
11. Explorer DLLダウンロード（非CI）
    └─ Windows Explorerコンテキストメニュー用
12. クライアントビルド
    └─ vscode-win32-$(VSCODE_ARCH)-min-ci実行
13. APPXパッケージ準備（非CI）
    └─ Microsoft Store用パッケージ
14. サーバービルド
    └─ vscode-reh-win32-$(VSCODE_ARCH)-min-ci実行
15. Webサーバービルド
    └─ vscode-reh-web-win32-$(VSCODE_ARCH)-min-ci実行
16. CLIダウンロード・統合（非CI）
    └─ Rust製CLIの組み込み
17. ESRPコード署名（非CI）
    └─ deemonプロセスでバックグラウンド署名
18. テスト実行（オプション）
    └─ Electron/Browser/Remoteテスト
19. アーティファクト移動・公開
    └─ 成果物の最終配置
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[Azure Key Vault シークレット取得]
    C --> D[Compilation artifact ダウンロード]
    D --> E{node_modules キャッシュ}
    E -->|ヒット| F[キャッシュ展開]
    E -->|ミス| G[npm ci 実行]
    F --> H[ディストリビューションミックスイン]
    G --> H
    H --> I[組み込み拡張機能インストール]
    I --> J{VSCODE_CIBUILD}
    J -->|false| K[Group Policy生成]
    J -->|true| L[クライアントビルド]
    K --> L
    L --> M[サーバービルド]
    M --> N[Webサーバービルド]
    N --> O{VSCODE_CIBUILD}
    O -->|false| P[CLI統合]
    O -->|true| Q{テスト実行?}
    P --> R[ESRP コード署名]
    R --> Q
    Q -->|Yes| S[テスト実行]
    Q -->|No| T[アーティファクト公開]
    S --> T
    T --> U[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可/パッケージ不整合 | 最大5回リトライ、レジストリ設定確認 |
| ESRP署名失敗 | 署名エラー | ESRP接続エラー/証明書エラー | サービス接続確認、再実行 |
| gulp失敗 | ビルドエラー | コンパイルエラー/リソース不足 | ログ確認、手動修正 |
| Key Vault取得失敗 | 認証エラー | サービスプリンシパル無効 | Azure AD設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. node_modulesキャッシュクリア: 必要に応じてキャッシュ削除後再実行
3. 成果物確認: クラッシュダンプ・ログアーティファクトを分析
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 90分以内（timeoutInMinutes: 90） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャ（x64/arm64）のビルドは並列実行可能ですが、同一ジョブの重複実行は行いません。node_modulesキャッシュは共有されますが、読み取り時にロックが適用されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |
| クラッシュダンプ | テスト失敗時 | .build/crashesディレクトリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 90分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |
| テスト失敗 | 1件以上 | パイプライン通知 |

## 備考

- ESRPコード署名はdeemonプロセスを使用してバックグラウンドで実行され、テストと並列化されます
- CIビルドモード（VSCODE_CIBUILD=true）では署名・インストーラー生成がスキップされ、ビルド検証のみ実行されます
- SDLセキュリティ抑制ファイルは`.config/guardian/.gdnsuppress`で管理されています
- Universal Binary対応のため、x64とarm64は別々にビルドされます
