# バッチ設計書 42-product-build-linux.yml

## 概要

本ドキュメントは、VS Code Linux版（x64/arm64/armhf）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、Linux向けクライアント、サーバー、Webサーバー、及びdeb/rpm/snapパッケージを生成します。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code Linux版をエンドユーザーに配布するためには、tar.gzアーカイブに加え、主要なLinuxディストリビューション向けのネイティブパッケージ（deb, rpm, snap）が必要です。本バッチは、ソースコードからコンパイル済みバイナリを取得し、GLIBC/GLIBCXX互換性を検証した上で、各種配布形式を生成します。また、リモート開発機能用のサーバーコンポーネントも同時にビルドします。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、mainブランチへのマージ時、release/*ブランチ更新時、または手動トリガー時に実行されます。

**主要な処理内容**：
1. コンパイル成果物（Compilation artifact）のダウンロードと展開
2. システムサービス（Xvfb）のセットアップ
3. VSCode sysrootのダウンロード（GLIBC 2.28互換）
4. node_modulesのキャッシュ復元または依存関係インストール
5. クライアントビルド（vscode-linux-$(VSCODE_ARCH)-min-ci）
6. サーバービルド（vscode-reh-linux-$(VSCODE_ARCH)-min-ci）
7. Webサーバービルド（vscode-reh-web-linux-$(VSCODE_ARCH)-min-ci）
8. GLIBC/GLIBCXX依存関係検証
9. debパッケージビルド
10. rpmパッケージビルド
11. snapパッケージビルド（x64のみ、オプション）
12. ESRPコード署名（deb/rpm）

**前後の処理との関連**：Compilationジョブで生成されたコンパイル成果物をダウンロードして使用します。CLIビルド（product-build-linux-cli）の成果物も統合します。後続でリポジトリ公開・CDNアップロードが行われます。

**影響範囲**：Linux版VS Codeの全配布形式、Ubuntu/Debian/RHEL系ディストリビューションのパッケージ管理、Snapストア、リモート開発機能に影響します。

## バッチ種別

プラットフォームビルド / ソフトウェアパッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Compilation artifact | コンパイル成果物が事前にパイプラインで生成されていること |
| Azure Key Vault | github-distro-mixin-passwordシークレットが取得可能であること |
| Docker Registry | vscodehub.azurecr.ioへのアクセスが可能であること |
| ESRP接続 | ESRPコード署名サービスへの接続が有効であること |

### 実行可否判定

パラメータVSCODE_CIBUILDがtrueの場合はCIビルドモードとなり、パッケージ生成や署名がスキップされます。VSCODE_BUILD_LINUX_SNAPがtrueの場合のみsnapパッケージが生成されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NPM_ARCH | string | Yes | - | npm用アーキテクチャ |
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64/armhf） |
| VSCODE_CIBUILD | boolean | Yes | - | CIビルドモードフラグ |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider） |
| VSCODE_BUILD_LINUX_SNAP | boolean | No | false | snapパッケージビルドフラグ |
| VSCODE_RUN_ELECTRON_TESTS | boolean | No | false | Electronテスト実行フラグ |
| VSCODE_RUN_BROWSER_TESTS | boolean | No | false | ブラウザテスト実行フラグ |
| VSCODE_RUN_REMOTE_TESTS | boolean | No | false | リモートテスト実行フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilation artifact | tar.gz | コンパイル済みTypeScriptコード |
| vscode_cli_linux_$(VSCODE_ARCH)_cli | tar.gz | Rust製CLIバイナリ |
| Azure Key Vault | シークレット | github-distro-mixin-password |
| VSCode sysroot | tar.gz | GLIBC 2.28互換sysroot |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_client_linux_$(VSCODE_ARCH)_archive-unsigned | tar.gz | クライアントアーカイブ |
| vscode_server_linux_$(VSCODE_ARCH)_archive-unsigned | tar.gz | リモート開発サーバー |
| vscode_web_linux_$(VSCODE_ARCH)_archive-unsigned | tar.gz | Webサーバー |
| vscode_client_linux_$(VSCODE_ARCH)_deb-package | deb | Debian/Ubuntuパッケージ |
| vscode_client_linux_$(VSCODE_ARCH)_rpm-package | rpm | RHEL/Fedoraパッケージ |
| vscode_client_linux_$(VSCODE_ARCH)_snap | snap | Snapパッケージ（x64のみ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | code-$(VSCODE_QUALITY)-$(VSCODE_ARCH)-$(timestamp).tar.gz / code_$(VERSION)_$(ARCH).deb / code-$(VERSION).$(ARCH).rpm |
| 出力先 | $(Build.ArtifactStagingDirectory)/out/{client,server,web,deb,rpm,snap} |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. システムサービスセットアップ
   └─ Xvfb、GTK、pkg-config等のインストール
4. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
5. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password
6. コンパイル成果物ダウンロード
   └─ Compilation artifactの展開
7. VSCode sysrootダウンロード
   └─ GLIBC 2.28互換sysrootの取得
8. node_modulesキャッシュ復元/インストール
   └─ 依存関係の準備
9. ディストリビューションミックスイン
   └─ npm modules、quality設定の適用
10. 組み込み拡張機能インストール
    └─ built-in extensionsの配置
11. ポリシー定義生成（非CI）
    └─ Linux用ポリシーファイル
12. クライアントビルド
    └─ vscode-linux-$(VSCODE_ARCH)-min-ci実行
13. CLI統合（非CI）
    └─ Rust製CLIの組み込み
14. クライアントアーカイブ作成
    └─ tar.gz圧縮
15. サーバービルド
    └─ vscode-reh-linux-$(VSCODE_ARCH)-min-ci実行
16. Webサーバービルド
    └─ vscode-reh-web-linux-$(VSCODE_ARCH)-min-ci実行
17. GLIBC/GLIBCXX依存関係検証
    └─ バージョン互換性チェック
18. debパッケージ準備・ビルド（非CI）
    └─ Debian形式パッケージ生成
19. rpmパッケージ準備・ビルド（非CI）
    └─ RPM形式パッケージ生成
20. snapパッケージビルド（x64、オプション）
    └─ Snapcraftによるビルド
21. ESRPコード署名（非CI）
    └─ deb/rpmの署名
22. テスト実行（オプション）
    └─ Electron/Browser/Remoteテスト
23. アーティファクト移動・公開
    └─ 成果物の最終配置
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[システムサービスセットアップ]
    C --> D[Azure Key Vault シークレット取得]
    D --> E[Compilation artifact ダウンロード]
    E --> F[VSCode sysroot ダウンロード]
    F --> G{node_modules キャッシュ}
    G -->|ヒット| H[キャッシュ展開]
    G -->|ミス| I[npm ci 実行]
    H --> J[ディストリビューションミックスイン]
    I --> J
    J --> K[組み込み拡張機能インストール]
    K --> L[クライアントビルド]
    L --> M[CLI統合]
    M --> N[サーバービルド]
    N --> O[Webサーバービルド]
    O --> P[GLIBC/GLIBCXX検証]
    P --> Q{VSCODE_CIBUILD}
    Q -->|false| R[debパッケージビルド]
    Q -->|true| S{テスト実行?}
    R --> T[rpmパッケージビルド]
    T --> U{VSCODE_BUILD_LINUX_SNAP & x64}
    U -->|Yes| V[snapパッケージビルド]
    U -->|No| W[ESRP署名]
    V --> W
    W --> S
    S -->|Yes| X[テスト実行]
    S -->|No| Y[アーティファクト公開]
    X --> Y
    Y --> Z[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可/パッケージ不整合 | 最大5回リトライ |
| GLIBC検証失敗 | 互換性エラー | 期待バージョン（2.28）と不一致 | sysroot設定確認 |
| debビルド失敗 | パッケージングエラー | dpkg-deb実行エラー | ログ確認、手動修正 |
| rpmビルド失敗 | パッケージングエラー | rpmbuild実行エラー | spec確認、手動修正 |
| snapビルド失敗 | パッケージングエラー | snapcraft実行エラー | Dockerイメージ確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. GLIBC/GLIBCXXエラー: sysrootのバージョンと設定を確認
3. パッケージビルドエラー: 個別のdpkg-deb/rpmbuild/snapcraftログを確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 90分以内（timeoutInMinutes: 90） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能ですが、同一ジョブの重複実行は行いません。Docker操作（snapビルド）時はvscodehub.azurecr.ioへのログインが必要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |
| クラッシュダンプ | テスト失敗時 | .build/crashesディレクトリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 90分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |
| GLIBC検証失敗 | 1回 | パイプライン通知 |

## 備考

- GLIBC 2.28/GLIBCXX 3.4.25（x64/arm64）または3.4.26（armhf）の互換性が必須です
- snapビルドはx64アーキテクチャかつVSCODE_BUILD_LINUX_SNAP=trueの場合のみ実行されます
- deb/rpmパッケージのxz圧縮が検証されます
- BinSkimによるセキュリティスキャンが設定されています（.nodeファイル対象）
- chrome-sandboxのSUIDビット除去が必要です（SBOM生成のため）
