# バッチ設計書 43-product-build-darwin.yml

## 概要

本ドキュメントは、VS Code macOS版（x64/arm64）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、macOS向けクライアント（.app）、サーバー、Webサーバーを生成し、Appleノータリゼーションとコード署名を実施します。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code macOS版をエンドユーザーに配布するためには、Apple Developer ID署名とノータリゼーション（公証）が施されたアプリケーションバンドルが必要です。本バッチは、ソースコードからコンパイル済みバイナリを取得し、Hardened Runtime対応の署名を施した上で、Appleの公証サービスに提出します。これにより、macOS Gatekeeperによるブロックを回避し、正規の配布が可能になります。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、mainブランチへのマージ時、release/*ブランチ更新時、または手動トリガー時に実行されます。

**主要な処理内容**：
1. コンパイル成果物（Compilation artifact）のダウンロードと展開
2. node_modulesのキャッシュ復元または依存関係インストール
3. ディストリビューション品質ミックスインの適用
4. 組み込み拡張機能のインストール
5. クライアントビルド（vscode-darwin-$(VSCODE_ARCH)-min-ci）
6. サーバービルド（vscode-reh-darwin-$(VSCODE_ARCH)-min-ci）
7. Webサーバービルド（vscode-reh-web-darwin-$(VSCODE_ARCH)-min-ci）
8. CLIのダウンロードと統合
9. Mach-Oアーキテクチャ検証
10. Hardened Entitlements設定
11. ESRPコード署名とノータリゼーション
12. 署名検証

**前後の処理との関連**：Compilationジョブで生成されたコンパイル成果物をダウンロードして使用します。CLIビルド（product-build-darwin-cli）の成果物も統合します。Universal Binary生成（product-build-darwin-universal）のために未署名アーカイブを公開します。

**影響範囲**：macOS版VS Codeの全配布形式、Apple Silicon/Intel Macサポート、リモート開発機能に影響します。

## バッチ種別

プラットフォームビルド / ソフトウェアパッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Compilation artifact | コンパイル成果物が事前にパイプラインで生成されていること |
| Azure Key Vault | github-distro-mixin-password、macos-developer-certificate、macos-developer-certificate-keyシークレットが取得可能であること |
| ESRP接続 | ESRPコード署名サービスへの接続が有効であること |
| Xcode | macOSエージェントにXcodeがインストールされていること |

### 実行可否判定

パラメータVSCODE_CIBUILDがtrueの場合はCIビルドモードとなり、コード署名やノータリゼーションがスキップされます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64） |
| VSCODE_CIBUILD | boolean | Yes | - | CIビルドモードフラグ |
| VSCODE_RUN_ELECTRON_TESTS | boolean | No | false | Electronテスト実行フラグ |
| VSCODE_RUN_BROWSER_TESTS | boolean | No | false | ブラウザテスト実行フラグ |
| VSCODE_RUN_REMOTE_TESTS | boolean | No | false | リモートテスト実行フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilation artifact | tar.gz | コンパイル済みTypeScriptコード |
| unsigned_vscode_cli_darwin_$(VSCODE_ARCH)_cli | zip | 署名前CLIバイナリ |
| Azure Key Vault | シークレット | github-distro-mixin-password、macos-developer-certificate、macos-developer-certificate-key |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_client_darwin_$(VSCODE_ARCH)_archive | zip | 署名済みクライアント（.app） |
| unsigned_vscode_client_darwin_$(VSCODE_ARCH)_archive | zip | 未署名クライアント（Universal Binary用） |
| vscode_server_darwin_$(VSCODE_ARCH)_archive-unsigned | zip | リモート開発サーバー |
| vscode_web_darwin_$(VSCODE_ARCH)_archive-unsigned | zip | Webサーバー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VSCode-darwin.zip（x64）/ VSCode-darwin-arm64.zip（arm64） |
| 出力先 | $(Build.ArtifactStagingDirectory)/out/vscode_client_darwin_$(VSCODE_ARCH)_archive |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
4. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password、macos-developer-certificate
5. コンパイル成果物ダウンロード
   └─ Compilation artifactの展開
6. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
7. node_modulesキャッシュ復元/インストール
   └─ 依存関係の準備（setuptools含む）
8. ディストリビューションミックスイン
   └─ npm modules、quality設定の適用
9. 組み込み拡張機能インストール
   └─ built-in extensionsの配置
10. ポリシー定義生成（非CI）
    └─ darwin用ポリシーファイル
11. クライアントビルド
    └─ vscode-darwin-$(VSCODE_ARCH)-min-ci実行
12. サーバービルド
    └─ vscode-reh-darwin-$(VSCODE_ARCH)-min-ci実行
13. Webサーバービルド
    └─ vscode-reh-web-darwin-$(VSCODE_ARCH)-min-ci実行
14. CLIダウンロード・統合（非CI）
    └─ Rust製CLIの組み込み
15. Mach-Oアーキテクチャ検証（非CI）
    └─ バイナリアーキテクチャの整合性確認
16. 未署名アーカイブ公開（非CI）
    └─ Universal Binary生成用
17. Hardened Entitlements設定（非CI）
    └─ Keychain作成、証明書インポート、署名
18. ESRPコード署名とノータリゼーション（非CI）
    └─ deemonプロセスでバックグラウンド実行
19. テスト実行（オプション）
    └─ Electron/Browser/Remoteテスト
20. 署名検証（非CI）
    └─ codesign -dv --deep --verbose=4
21. アーティファクト移動・公開
    └─ 成果物の最終配置
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[Azure Key Vault シークレット取得]
    C --> D[Compilation artifact ダウンロード]
    D --> E{node_modules キャッシュ}
    E -->|ヒット| F[キャッシュ展開]
    E -->|ミス| G[npm ci 実行]
    F --> H[ディストリビューションミックスイン]
    G --> H
    H --> I[組み込み拡張機能インストール]
    I --> J[クライアントビルド]
    J --> K[サーバービルド]
    K --> L[Webサーバービルド]
    L --> M{VSCODE_CIBUILD}
    M -->|false| N[CLI統合]
    M -->|true| O{テスト実行?}
    N --> P[Mach-O検証]
    P --> Q[未署名アーカイブ公開]
    Q --> R[Hardened Entitlements設定]
    R --> S[ESRP署名・ノータリゼーション]
    S --> O
    O -->|Yes| T[テスト実行]
    O -->|No| U[署名検証]
    T --> U
    U --> V[アーティファクト公開]
    V --> W[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可/パッケージ不整合 | 最大5回リトライ |
| Mach-O検証失敗 | アーキテクチャエラー | バイナリが異なるアーキテクチャ | ビルド設定確認 |
| 署名失敗 | 証明書エラー | 証明書無効/期限切れ | Key Vault設定確認 |
| ノータリゼーション失敗 | Apple審査エラー | コード要件違反 | Apple審査結果確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. 証明書エラー: Key Vaultの証明書状態確認
3. ノータリゼーションエラー: Appleの審査結果確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 90分以内（timeoutInMinutes: 90） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能ですが、同一ジョブの重複実行は行いません。Keychain操作は一時ファイルを使用して分離されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |
| 署名ログ | 署名実行時 | DEBUG=electron-osx-sign* |
| クラッシュダンプ | テスト失敗時 | .build/crashesディレクトリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 90分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |
| 署名失敗 | 1回 | パイプライン通知 |

## 備考

- 未署名アーカイブはUniversal Binary生成（x64+arm64統合）に使用されます
- Hardened Entitlementsは、AppleノータリゼーションとmacOS Big Sur以降でのテスト実行に必要です
- Keychainは一時ディレクトリに作成され、パスワード"pwd"で保護されます
- GYP_DEFINES="kerberos_use_rtld=false"はKerberos関連の動的ロード問題を回避します
- x64の場合はVSCode-darwin.zip、arm64の場合はVSCode-darwin-arm64.zipという命名規則です
- 署名検証後、デフォルト設定のエクスポートテストも実行されます
