# バッチ設計書 44-product-build-alpine.yml

## 概要

本ドキュメントは、VS Code Alpine Linux版（x64/arm64）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、musl libc環境向けのサーバーコンポーネントを生成します。

### 本バッチの処理概要

**業務上の目的・背景**：Alpine Linuxはmusl libcを使用する軽量Linuxディストリビューションであり、Docker公式イメージで広く採用されています。VS Codeリモート開発機能をAlpine Linuxコンテナ内で使用するためには、musl libc向けにビルドされたサーバーコンポーネントが必要です。本バッチは、musl互換のNode.jsとネイティブモジュールを使用してリモート開発サーバーおよびWebサーバーをビルドします。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、mainブランチへのマージ時、release/*ブランチ更新時、または手動トリガー時に実行されます。

**主要な処理内容**：
1. コンパイル成果物（Compilation artifact）のダウンロードと展開
2. NodeJS MUSL版のダウンロード
3. Dockerコンテナを使用したnpmモジュールビルド
4. リモート開発サーバービルド（vscode-reh-linux-alpine/alpine-arm64-min-ci）
5. Webサーバービルド（vscode-reh-web-linux-alpine/alpine-arm64-min-ci）

**前後の処理との関連**：Compilationジョブで生成されたコンパイル成果物をダウンロードして使用します。microsoft/vscode-nodeリポジトリからmusl版Node.jsを取得します。後続でCDNアップロードが行われます。

**影響範囲**：Alpine LinuxベースのDocker環境でのVS Codeリモート開発機能、vscode.dev対応に影響します。

## バッチ種別

プラットフォームビルド / サーバーコンポーネントビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Compilation artifact | コンパイル成果物が事前にパイプラインで生成されていること |
| Azure Key Vault | github-distro-mixin-passwordシークレットが取得可能であること |
| Docker Registry | vscodehub.azurecr.ioへのアクセスが可能であること |
| GitHub Access | microsoft/vscode-nodeリポジトリへのアクセスが可能であること |

### 実行可否判定

VSCODE_ARCHパラメータに応じて、x64またはarm64向けのビルドが実行されます。Alpineビルドはサーバーコンポーネントのみを生成し、クライアントビルドは含まれません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilation artifact | tar.gz | コンパイル済みTypeScriptコード |
| Azure Key Vault | シークレット | github-distro-mixin-password |
| microsoft/vscode-node | tar.gz | NodeJS MUSL版バイナリ |
| vscodehub.azurecr.io | Dockerイメージ | vscode-linux-build-agent:alpine-$(VSCODE_ARCH) |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_server_linux_alpine_archive-unsigned（x64） | tar.gz | x64向けリモート開発サーバー |
| vscode_web_linux_alpine_archive-unsigned（x64） | tar.gz | x64向けWebサーバー |
| vscode_server_alpine_$(VSCODE_ARCH)_archive-unsigned（arm64） | tar.gz | arm64向けリモート開発サーバー |
| vscode_web_alpine_$(VSCODE_ARCH)_archive-unsigned（arm64） | tar.gz | arm64向けWebサーバー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | vscode-server-linux-alpine.tar.gz（x64）/ vscode-server-alpine-$(VSCODE_ARCH).tar.gz（arm64） |
| 出力先 | $(Build.ArtifactStagingDirectory)/out/{server,web} |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
4. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password
5. コンパイル成果物ダウンロード
   └─ Compilation artifactの展開
6. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
7. node_modulesキャッシュ復元/インストール
   └─ キャッシュキー: alpine $(VSCODE_ARCH)
8. Dockerイメージプル（キャッシュミス時）
   └─ vscode-linux-build-agent:alpine-$(VSCODE_ARCH)
9. ビルド依存関係インストール（キャッシュミス時）
   └─ libkrb5-dev
10. NodeJS MUSLダウンロード（キャッシュミス時）
    └─ microsoft/vscode-nodeから取得
11. npm ci実行（キャッシュミス時）
    └─ Dockerコンテナ内でネイティブモジュールビルド
12. ディストリビューションミックスイン
    └─ npm modules、quality設定の適用
13. 組み込み拡張機能インストール
    └─ built-in extensionsの配置
14. サーバービルド
    └─ vscode-reh-{linux-alpine|alpine-arm64}-min-ci実行
15. Webサーバービルド
    └─ vscode-reh-web-{linux-alpine|alpine-arm64}-min-ci実行
16. アーカイブ作成・公開
    └─ tar.gz形式で圧縮
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[Azure Key Vault シークレット取得]
    C --> D[Compilation artifact ダウンロード]
    D --> E{node_modules キャッシュ}
    E -->|ヒット| F[キャッシュ展開]
    E -->|ミス| G[Dockerイメージプル]
    F --> H[ディストリビューションミックスイン]
    G --> I[ビルド依存関係インストール]
    I --> J[NodeJS MUSLダウンロード]
    J --> K[npm ci実行]
    K --> L[node_modules cache作成]
    L --> H
    H --> M[組み込み拡張機能インストール]
    M --> N[サーバービルド]
    N --> O[Webサーバービルド]
    O --> P[アーカイブ作成]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可/ネイティブモジュールビルドエラー | 最大5回リトライ |
| Dockerプル失敗 | イメージ取得エラー | vscodehub.azurecr.io接続不可 | レジストリ設定確認 |
| NodeJS MUSLダウンロード失敗 | GitHub APIエラー | レート制限/リポジトリアクセス不可 | GITHUB_TOKEN確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. Dockerエラー: コンテナレジストリへのアクセス確認
3. NodeJS MUSL取得エラー: GitHub API制限確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 30分以内（timeoutInMinutes: 30） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能ですが、同一ジョブの重複実行は行いません。Dockerコンテナはホストマウント（/mnt/vss/_work/1/s）を使用します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |

## 備考

- Alpineビルドはリモート開発サーバーとWebサーバーのみを生成します（クライアントアプリなし）
- x64ビルドのターゲット名は"linux-alpine"、arm64は"alpine-arm64"と命名規則が異なります（TODO@joaomoreno）
- musl libc互換のネイティブモジュールはDockerコンテナ内でビルドされます
- NodeJS MUSL版はmicrosoft/vscode-nodeリポジトリからGitHub Release経由で取得されます
- プール指定: 1es-ubuntu-22.04-x64（Linux UbuntuホストでDockerを使用）
- VSCODE_HOST_MOUNT: /mnt/vss/_work/1/s がコンテナにマウントされます
