# バッチ設計書 45-product-build-web.yml

## 概要

本ドキュメントは、VS Code Web版（vscode.dev向け）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、ブラウザで動作するスタンドアロンのWeb版VS Codeを生成し、CDNおよびAzure Storageへデプロイします。

### 本バッチの処理概要

**業務上の目的・背景**：vscode.devはブラウザ上で動作するVS Codeであり、インストール不要でどこからでもコード編集が可能です。本バッチは、ElectronやNode.jsに依存しないWeb専用のVS Codeバンドルを生成し、静的アセットとしてCDNにアップロードします。また、デバッグ用のソースマップと国際化（NLS）メタデータも同時にアップロードします。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、mainブランチへのマージ時、release/*ブランチ更新時、または手動トリガー時に実行されます。

**主要な処理内容**：
1. コンパイル成果物（Compilation artifact）のダウンロードと展開
2. node_modulesのキャッシュ復元または依存関係インストール
3. ディストリビューション品質ミックスインの適用
4. 組み込み拡張機能のインストール
5. Web版ビルド（vscode-web-min-ci）
6. CDNへの静的アセットアップロード
7. ソースマップのアップロード
8. NLSメタデータのアップロード

**前後の処理との関連**：Compilationジョブで生成されたコンパイル成果物をダウンロードして使用します。Azure Storage "vscodeweb"アカウントへのデプロイが行われます。

**影響範囲**：vscode.devサービス、ブラウザ版VS Codeの全機能、国際化対応に影響します。

## バッチ種別

プラットフォームビルド / Webアプリケーションデプロイ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Compilation artifact | コンパイル成果物が事前にパイプラインで生成されていること |
| Azure Key Vault | github-distro-mixin-passwordシークレットが取得可能であること |
| Azure Storage | vscodeweb ストレージアカウントへのアクセスが可能であること |
| Azure CLI | AzureCLIタスクによるサービスプリンシパル認証が可能であること |

### 実行可否判定

Webビルドは常に実行されます。テストパラメータは存在せず、ビルドとデプロイのみを行います。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （パラメータなし） | - | - | - | 固定設定で実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilation artifact | tar.gz | コンパイル済みTypeScriptコード |
| Azure Key Vault | シークレット | github-distro-mixin-password |
| Azure Service Principal | トークン | CDNアップロード用認証情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_web_linux_standalone_archive-unsigned | tar.gz | Web版アーカイブ（パイプラインアーティファクト） |
| vscodeweb Azure Storage | 静的ファイル | CDN経由で配信されるアセット |
| ソースマップ | .js.map | デバッグ用ソースマップ |
| NLSメタデータ | JSON | 国際化用メタデータ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | vscode-web.tar.gz |
| 出力先 | $(Build.ArtifactStagingDirectory)/out/web |
| 文字コード | UTF-8（静的ファイル） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
4. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password
5. コンパイル成果物ダウンロード
   └─ Compilation artifactの展開
6. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
7. node_modulesキャッシュ復元/インストール
   └─ 依存関係の準備
8. システムサービスセットアップ
   └─ libkrb5-devインストール
9. ディストリビューションミックスイン
   └─ npm modules、quality設定の適用
10. 組み込み拡張機能インストール
    └─ built-in extensionsの配置
11. Webビルド
    └─ vscode-web-min-ci実行
12. Azure認証情報取得
    └─ サービスプリンシパルからIDトークン取得
13. CDNアップロード
    └─ upload-cdn.ts実行
14. ソースマップアップロード
    └─ upload-sourcemaps.ts実行
15. NLSメタデータアップロード
    └─ upload-nlsmetadata.ts実行
16. アーカイブ公開
    └─ パイプラインアーティファクトとして公開
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[Azure Key Vault シークレット取得]
    C --> D[Compilation artifact ダウンロード]
    D --> E{node_modules キャッシュ}
    E -->|ヒット| F[キャッシュ展開]
    E -->|ミス| G[npm ci 実行]
    F --> H[ディストリビューションミックスイン]
    G --> H
    H --> I[組み込み拡張機能インストール]
    I --> J[Webビルド]
    J --> K[Azure認証情報取得]
    K --> L[CDNアップロード]
    L --> M[ソースマップアップロード]
    M --> N[NLSメタデータアップロード]
    N --> O[アーカイブ公開]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可/パッケージ不整合 | 最大5回リトライ |
| CDNアップロード失敗 | Azure Storageエラー | 認証エラー/ストレージ接続不可 | サービスプリンシパル確認 |
| ソースマップアップロード失敗 | Azure Storageエラー | 認証エラー/ファイルサイズ超過 | アップロードスクリプト確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. Azure認証エラー: サービスプリンシパル設定確認
3. CDNアップロードエラー: ストレージアカウント設定確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム・クラウドストレージ操作） |
| コミットタイミング | 各アップロードステップ完了時 |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない（CDNアップロードは部分的に完了の可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 30分以内（timeoutInMinutes: 30） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一パイプラインの重複実行は行いません。CDNアップロードは追加・更新操作であり、既存ファイルの上書きが発生します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名 |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |
| CDNアップロード失敗 | 1回 | パイプライン通知 |

## 備考

- VSCODE_ARCHは固定でx64が使用されます（Webビルドはアーキテクチャ非依存）
- Azure Storage認証はワークロードIDフェデレーション（OIDC）を使用します
- AZURE_ID_TOKENはAzureCLIタスクから取得され、環境変数として渡されます
- ソースマップは`out-vscode-web-min/vs/workbench/workbench.web.main.internal.js.map`が対象です
- プール指定: 1es-ubuntu-22.04-x64（Linux Ubuntu）
- SBOM（Software Bill of Materials）が生成されます（sbomBuildDropPath: vscode-web）
