# バッチ設計書 46-product-build-win32-cli.yml

## 概要

本ドキュメントは、VS Code Windows CLI（x64/arm64）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、Rust言語で実装されたコマンドラインインターフェース（CLI）をWindowsプラットフォーム向けにビルドします。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code CLIは、リモートトンネル接続やコマンドラインからのVS Code操作を可能にするRust製のツールです。Windows版クライアントに統合されるため、Windows向けにネイティブバイナリとしてビルドする必要があります。本バッチは、Rustツールチェーンを使用してセキュリティ強化オプション（Control Flow Guard、CET）を有効にしたCLIバイナリを生成します。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、メインのWindowsビルドより先に実行されます。生成された成果物は後続のproduct-build-win32ジョブで統合されます。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. CLIパッチの適用
3. OpenSSLプレビルドバイナリのダウンロードと展開
4. Rustツールチェーンのインストール（MSVCターゲット）
5. Rustコンパイル（セキュリティフラグ付き）
6. 未署名CLIアーティファクトの公開

**前後の処理との関連**：独立して実行され、成果物はproduct-build-win32ジョブでダウンロードされてクライアントアプリに統合されます。署名はproduct-build-win32のESRP署名プロセスで行われます。

**影響範囲**：VS Code Windows版のCLI機能、リモートトンネル接続機能に影響します。

## バッチ種別

CLIビルド / ネイティブバイナリコンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンが利用可能であること |
| Rust | msrustupによるRustツールチェーンインストールが可能であること |
| OpenSSL | Monaco/openssl-prebuiltフィードからダウンロード可能であること |

### 実行可否判定

パラメータVSCODE_CHECK_ONLYがtrueの場合は、コンパイルチェックのみを行いアーティファクトは公開されません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64） |
| VSCODE_CHECK_ONLY | boolean | No | false | コンパイルチェックのみ実行フラグ |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | Git | cli/ディレクトリのRustソース |
| @vscode-internal/openssl-prebuilt | tgz | OpenSSLプレビルドバイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| unsigned_vscode_cli_win32_$(VSCODE_ARCH)_cli | zip | 未署名CLIバイナリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | unsigned_vscode_cli_win32_$(VSCODE_ARCH)_cli.zip |
| 出力先 | $(Build.ArtifactStagingDirectory) |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. CLIパッチ適用
   └─ cli-apply-patches.ymlテンプレート実行
4. OpenSSLダウンロード
   └─ @vscode-internal/openssl-prebuilt@0.0.11取得
5. OpenSSL展開
   └─ アーキテクチャ別ディレクトリに配置
6. Rustインストール
   └─ msrustupによるツールチェーンセットアップ
7. Rustターゲット追加
   └─ x86_64-pc-windows-msvc または aarch64-pc-windows-msvc
8. Rustコンパイル
   └─ セキュリティフラグ付きでビルド
9. アーティファクト公開（非CHECK_ONLY）
   └─ 未署名zipアーカイブとして公開
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[CLIパッチ適用]
    C --> D[OpenSSLダウンロード]
    D --> E[OpenSSL展開]
    E --> F[Rustインストール]
    F --> G{VSCODE_ARCH}
    G -->|x64| H[x86_64-pc-windows-msvc]
    G -->|arm64| I[aarch64-pc-windows-msvc]
    H --> J[Rustコンパイル]
    I --> J
    J --> K{VSCODE_CHECK_ONLY}
    K -->|false| L[アーティファクト公開]
    K -->|true| M[チェック完了]
    L --> N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Rustコンパイル失敗 | ビルドエラー | ソースコードエラー/依存関係エラー | ログ確認、コード修正 |
| OpenSSLダウンロード失敗 | フィード接続エラー | Monaco/openssl-prebuiltアクセス不可 | フィード設定確認 |
| ターゲットインストール失敗 | Rustセットアップエラー | rustupエラー | ツールチェーン設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 明示的なリトライ設定なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. Rustコンパイルエラー: cargoビルドログを詳細確認
3. OpenSSLエラー: フィード認証確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 30分以内（timeoutInMinutes: 30） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能です。x64とarm64は異なるジョブとして実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |

## 備考

- セキュリティフラグ:
  - `-Ctarget-feature=+crt-static`: 静的CRTリンク
  - `-Clink-args=/guard:cf`: Control Flow Guard有効化
  - `-Clink-args=/CETCOMPAT`: CET（Control-flow Enforcement Technology）有効化（x64のみ、arm64は/CETCOMPAT:NO）
  - `CFLAGS="/guard:cf /Qspectre"`: Spectre軽減策有効化
- OpenSSLは静的リンクされ、ライブラリパスはVSCODE_ARCHに応じて設定されます
- プール指定: 1es-windows-2022-x64
- SBOMは無効（isProduction: false）
