# バッチ設計書 47-product-build-linux-cli.yml

## 概要

本ドキュメントは、VS Code Linux CLI（x64/arm64/armhf）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、Rust言語で実装されたコマンドラインインターフェース（CLI）をLinuxプラットフォーム向けにビルドします。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code CLIは、リモートトンネル接続やコマンドラインからのVS Code操作を可能にするRust製のツールです。Linux版クライアントに統合されるため、各Linuxアーキテクチャ（x64、arm64、armhf）向けにネイティブバイナリとしてビルドする必要があります。本バッチは、クロスコンパイル環境を使用して複数アーキテクチャ向けのCLIバイナリを生成します。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、メインのLinuxビルドより先に実行されます。生成された成果物は後続のproduct-build-linuxジョブで統合されます。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. CLIパッチの適用
3. OpenSSLプレビルドバイナリのダウンロードと展開
4. NPMレジストリセットアップと認証
5. ビルド依存関係のインストール
6. Rustツールチェーンのインストール（GNU ターゲット）
7. sysrootを使用したクロスコンパイル
8. tar.gz形式でCLIアーティファクトを公開

**前後の処理との関連**：独立して実行され、成果物はproduct-build-linuxジョブでダウンロードされてクライアントアプリに統合されます。SBOMが生成されます。

**影響範囲**：VS Code Linux版のCLI機能、リモートトンネル接続機能に影響します。

## バッチ種別

CLIビルド / ネイティブバイナリコンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンが利用可能であること |
| Rust | install-rust-posix.ymlによるRustツールチェーンインストールが可能であること |
| OpenSSL | Monaco/openssl-prebuiltフィードからダウンロード可能であること |
| GitHub Token | github-distro-mixin-passwordが利用可能であること |

### 実行可否判定

パラメータVSCODE_CHECK_ONLYがtrueの場合は、コンパイルチェックのみを行いアーティファクトは公開されません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64/armhf） |
| VSCODE_CHECK_ONLY | boolean | No | false | コンパイルチェックのみ実行フラグ |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | Git | cli/ディレクトリのRustソース |
| @vscode-internal/openssl-prebuilt | tgz | OpenSSLプレビルドバイナリ |
| Azure Key Vault | シークレット | github-distro-mixin-password |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_cli_linux_$(VSCODE_ARCH)_cli | tar.gz | CLIバイナリアーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | vscode_cli_linux_$(VSCODE_ARCH)_cli.tar.gz |
| 出力先 | $(Build.ArtifactStagingDirectory) |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. CLIパッチ適用
   └─ cli-apply-patches.ymlテンプレート実行
4. OpenSSLダウンロード
   └─ @vscode-internal/openssl-prebuilt@0.0.11取得
5. OpenSSL展開
   └─ アーキテクチャ別ディレクトリに配置
6. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
7. NPM認証
   └─ npmAuthenticate実行
8. ビルド依存関係インストール
   └─ npm ci（build/ディレクトリ）
9. .buildディレクトリ作成
   └─ 依存関係配置用
10. Rustインストール
    └─ install-rust-posix.ymlテンプレート実行
11. Rustターゲット追加
    └─ x86_64-unknown-linux-gnu / aarch64-unknown-linux-gnu / armv7-unknown-linux-gnueabihf
12. Rustコンパイル
    └─ sysrootを使用したクロスコンパイル
13. アーティファクト公開（非CHECK_ONLY）
    └─ SBOM付きtar.gzアーカイブとして公開
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[CLIパッチ適用]
    C --> D[OpenSSLダウンロード・展開]
    D --> E[NPMレジストリセットアップ・認証]
    E --> F[ビルド依存関係インストール]
    F --> G[Rustインストール]
    G --> H{VSCODE_ARCH}
    H -->|x64| I[x86_64-unknown-linux-gnu]
    H -->|arm64| J[aarch64-unknown-linux-gnu]
    H -->|armhf| K[armv7-unknown-linux-gnueabihf]
    I --> L[Rustコンパイル]
    J --> L
    K --> L
    L --> M{VSCODE_CHECK_ONLY}
    M -->|false| N[アーティファクト公開]
    M -->|true| O[チェック完了]
    N --> P[バッチ終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Rustコンパイル失敗 | ビルドエラー | ソースコードエラー/依存関係エラー | ログ確認、コード修正 |
| OpenSSLダウンロード失敗 | フィード接続エラー | Monaco/openssl-prebuiltアクセス不可 | フィード設定確認 |
| npm ci失敗 | 依存関係エラー | npm registry接続不可 | 最大5回リトライ |
| sysrootエラー | クロスコンパイルエラー | sysroot設定不正 | SYSROOT_ARCH確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. Rustコンパイルエラー: cargoビルドログを詳細確認
3. クロスコンパイルエラー: sysroot設定、OpenSSLパス確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 60分以内（timeoutInMinutes: 60） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能です。x64、arm64、armhfは異なるジョブとして実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |

## 備考

- Rustターゲット:
  - x64: x86_64-unknown-linux-gnu
  - arm64: aarch64-unknown-linux-gnu
  - armhf: armv7-unknown-linux-gnueabihf
- OpenSSLライブラリパス:
  - x64: openssl/x64-linux/lib
  - arm64: openssl/arm64-linux/lib
  - armhf: openssl/arm-linux/lib
- SYSROOT_ARCH設定:
  - x64: amd64
  - arm64: arm64
  - armhf: armhf
- プール指定: 1es-ubuntu-22.04-x64
- SBOMが生成されます（sbomPackageName: "VS Code Linux $(VSCODE_ARCH) CLI"）
