# バッチ設計書 49-product-build-alpine-cli.yml

## 概要

本ドキュメントは、VS Code Alpine Linux CLI（x64/arm64）のビルドパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、Rust言語で実装されたコマンドラインインターフェース（CLI）をmusl libc環境向けにビルドします。

### 本バッチの処理概要

**業務上の目的・背景**：VS Code CLIは、リモートトンネル接続やコマンドラインからのVS Code操作を可能にするRust製のツールです。Alpine Linuxはmusl libcを使用する軽量Linuxディストリビューションであり、Docker環境で広く使用されています。本バッチは、musl向けにRustバイナリをビルドし、Alpine Linuxコンテナ内でのCLI利用を可能にします。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、メインのAlpineビルドとは独立して実行されます。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. CLIパッチの適用
3. ビルド依存関係のインストール（npm ci）
4. OpenSSLプレビルドバイナリのダウンロードと展開
5. muslビルド依存関係のインストール（musl-dev, musl-tools等）
6. Rustツールチェーンのインストール（muslターゲット）
7. Rustコンパイル（静的OpenSSLリンク）
8. tar.gz形式でCLIアーティファクトを公開

**前後の処理との関連**：独立して実行されます。Alpine版はサーバーコンポーネントのみをビルドするため、CLIは個別に配布されることがあります。

**影響範囲**：Alpine LinuxベースのDocker環境でのVS Code CLI機能、リモートトンネル接続機能に影響します。

## バッチ種別

CLIビルド / ネイティブバイナリコンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンが利用可能であること |
| Rust | install-rust-posix.ymlによるRustツールチェーンインストールが可能であること |
| OpenSSL | Monaco/openssl-prebuiltフィードからダウンロード可能であること |
| musl-tools | musl-gcc、musl-devがインストール可能であること |
| GitHub Token | github-distro-mixin-passwordが利用可能であること |

### 実行可否判定

パラメータVSCODE_CHECK_ONLYがtrueの場合は、コンパイルチェックのみを行いアーティファクトは公開されません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64/arm64） |
| VSCODE_CHECK_ONLY | boolean | No | false | コンパイルチェックのみ実行フラグ |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | Git | cli/ディレクトリのRustソース |
| @vscode-internal/openssl-prebuilt | tgz | OpenSSLプレビルドバイナリ（musl版） |
| Azure Key Vault | シークレット | github-distro-mixin-password |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vscode_cli_alpine_$(VSCODE_ARCH)_cli | tar.gz | CLIバイナリアーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | vscode_cli_alpine_$(VSCODE_ARCH)_cli.tar.gz |
| 出力先 | $(Build.ArtifactStagingDirectory) |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js環境の準備
3. CLIパッチ適用
   └─ cli-apply-patches.ymlテンプレート実行
4. ビルド依存関係インストール
   └─ npm ci（build/ディレクトリ）
5. OpenSSLダウンロード
   └─ @vscode-internal/openssl-prebuilt@0.0.11取得
6. OpenSSL展開
   └─ アーキテクチャ別ディレクトリに配置
7. muslビルド依存関係インストール
   └─ build-essential, musl-dev, musl-tools, linux-libc-dev, pkgconf, xutils-dev, lld
8. musl-g++シンボリックリンク作成
   └─ ln -s /usr/bin/g++ /usr/bin/musl-g++
9. Rustインストール
   └─ install-rust-posix.ymlテンプレート実行
10. Rustターゲット追加
    └─ x86_64-unknown-linux-musl または aarch64-unknown-linux-musl
11. Rustコンパイル
    └─ OPENSSL_STATIC=1で静的リンク
12. アーティファクト公開（非CHECK_ONLY）
    └─ SBOM付きtar.gzアーカイブとして公開
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[CLIパッチ適用]
    C --> D[npm ci 実行]
    D --> E[OpenSSLダウンロード・展開]
    E --> F[muslビルド依存関係インストール]
    F --> G[musl-g++シンボリックリンク作成]
    G --> H[Rustインストール]
    H --> I{VSCODE_ARCH}
    I -->|x64| J[x86_64-unknown-linux-musl]
    I -->|arm64| K[aarch64-unknown-linux-musl]
    J --> L[Rustコンパイル]
    K --> L
    L --> M{VSCODE_CHECK_ONLY}
    M -->|false| N[アーティファクト公開]
    M -->|true| O[チェック完了]
    N --> P[バッチ終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作は存在しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Rustコンパイル失敗 | ビルドエラー | ソースコードエラー/musl互換性エラー | ログ確認、コード修正 |
| OpenSSLダウンロード失敗 | フィード接続エラー | Monaco/openssl-prebuiltアクセス不可 | フィード設定確認 |
| musl-toolsインストール失敗 | apt-getエラー | パッケージ取得不可 | リポジトリ確認 |
| npm ci失敗 | 依存関係エラー | npm registry接続不可 | レジストリ設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 明示的なリトライ設定なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. Rustコンパイルエラー: cargoビルドログを詳細確認
3. muslエラー: musl-tools、musl-devのインストール状態確認
4. 手動再実行: パイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | ジョブ失敗時は成果物が公開されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 60分以内（timeoutInMinutes: 60） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一アーキテクチャのビルドは並列実行可能です。x64とarm64は異なるジョブとして実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60分超過 | Azure Pipelinesタイムアウト |
| ビルド失敗 | 1回 | パイプライン通知 |

## 備考

- Rustターゲット:
  - x64: x86_64-unknown-linux-musl
  - arm64: aarch64-unknown-linux-musl
- OpenSSLライブラリパス:
  - x64: openssl/x64-linux-musl/lib
  - arm64: openssl/arm64-linux-musl/lib
- OPENSSL_STATIC=1が設定され、OpenSSLが静的リンクされます
- muslビルドの参考: https://github.com/emk/rust-musl-builder/blob/main/Dockerfile
- arm64の場合、追加設定:
  - SYSROOT_ARCH: arm64
  - IS_MUSL: 1
- musl-g++シンボリックリンク作成時に「link exists」エラーは無視されます
- プール指定: 1es-ubuntu-22.04-x64（UbuntuホストでmuslクロスコンパイルL）
- SBOMが生成されます（sbomPackageName: "VS Code Alpine $(VSCODE_ARCH) CLI"）
