# バッチ設計書 5-publish-types

## 概要

本ドキュメントは、@types/vscodeの公開パイプライン「publish-types」の設計仕様を定義するものです。VSCodeリリース時にDefinitelyTypedリポジトリへPull Requestを作成し、TypeScript型定義ファイルを公開する処理を担当します。

### 本バッチの処理概要

本バッチは、VSCodeの新しいバージョンがリリースされた際に、VSCode Extension APIの型定義ファイルをDefinitelyTypedリポジトリに反映するための自動化パイプラインです。タグプッシュをトリガーとして、型定義の更新ブランチを作成し、Slackを通じてレビュー担当者に通知します。

**業務上の目的・背景**：VSCodeの拡張機能開発者は、@types/vscodeパッケージを通じてVSCode Extension APIの型定義を利用します。新しいAPIが追加された際に、型定義を迅速にDefinitelyTypedに反映することで、拡張機能開発者が最新のAPIを型安全に使用できるようになります。本バッチにより、この型定義の公開プロセスが自動化され、リリースサイクルに同期した型定義の提供が可能になっています。

**バッチの実行タイミング**：GitHubリポジトリへのタグプッシュ時に自動実行されます。通常、VSCodeのリリースビルド完了後にバージョンタグがプッシュされたタイミングで動作します。

**主要な処理内容**：
1. タグバージョンの取得と1.999.0タグのチェック
2. バージョン整合性の確認（check-version.ts）
3. DefinitelyTypedリポジトリのクローン
4. 型定義ファイルの更新（update-types.ts）
5. 更新ブランチの作成とプッシュ
6. Slackへの通知（PR作成依頼）

**前後の処理との関連**：本バッチは、VSCodeのリリースプロセスの一部として、製品リリース後に型定義を公開するために実行されます。DefinitelyTypedへのPR作成後は、手動でのレビューとマージが必要です。

**影響範囲**：DefinitelyTypedリポジトリ（vscode-types-*ブランチ）、npmの@types/vscodeパッケージ（マージ後）、VSCode Teamの#C1C14HJ2F Slackチャンネルに影響します。

## バッチ種別

CI/CDパイプライン（型定義公開）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | タグプッシュ時 |
| 実行時刻 | タグプッシュのタイミング |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | refs/tags/* へのプッシュ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| タグ | refs/tags/* 形式のタグがプッシュされていること |
| タグバージョン | 1.999.0 でないこと |
| 認証情報 | GITHUB_TOKEN（DefinitelyTypedへのアクセス用） |
| 認証情報 | SLACK_TOKEN（Slack通知用） |
| ビルドエージェント | ubuntu-latest |

### 実行可否判定

- タグが1.999.0の場合、エラーを出力して終了（テスト用タグの誤プッシュ防止）
- check-version.tsでバージョンの整合性を検証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TAG_VERSION | string | Yes | (git describeから取得) | リリースタグバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub microsoft/vscode | Git Repository | VSCodeソースコード |
| GitHub DefinitelyTyped/DefinitelyTyped | Git Repository | 型定義リポジトリ（depth=1でクローン） |
| Azure DevOps Variables | Secret | GITHUB_TOKEN, SLACK_TOKEN |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| DefinitelyTyped/DefinitelyTyped | Git Branch | vscode-types-{TAG_VERSION}ブランチ |
| Slack #C1C14HJ2F | メッセージ | PR作成依頼通知 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | types/vscode/index.d.ts 等 |
| 出力先 | DefinitelyTyped/types/vscode/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
2. 1.999.0タグチェック
   └─ git describe --tagsでタグ取得
   └─ 1.999.0の場合、Slack通知してexit 1
3. バージョンチェック
   └─ build/azure-pipelines/publish-types/check-version.ts
4. Git設定
   └─ user.email: vscode@microsoft.com
   └─ user.name: VSCode
5. DefinitelyTypedクローン
   └─ depth=1でshallow clone
6. 型定義更新
   └─ build/azure-pipelines/publish-types/update-types.ts
7. 変更確認
   └─ git diff --color | cat
8. ブランチ作成・プッシュ
   └─ vscode-types-{TAG_VERSION}ブランチ作成
   └─ コミットメッセージ: "VS Code {TAG_VERSION} Extension API"
   └─ リモートにプッシュ
9. Slack通知
   └─ #C1C14HJ2F チャンネルに3つのメッセージ送信
   └─ ブランチ作成通知
   └─ PR作成リンク
   └─ レビュー担当者への通知
```

### フローチャート

```mermaid
flowchart TD
    A[タグプッシュトリガー] --> B[Node.jsセットアップ]
    B --> C[タグバージョン取得]
    C --> D{1.999.0タグ?}
    D -->|Yes| E[Slack警告通知]
    E --> F[エラー終了]
    D -->|No| G[バージョンチェック]
    G --> H[DefinitelyTypedクローン]
    H --> I[update-types.ts実行]
    I --> J[変更diff確認]
    J --> K[ブランチ作成]
    K --> L[コミット作成]
    L --> M[リモートプッシュ]
    M --> N[Slack通知: ブランチ作成]
    N --> O[Slack通知: PRリンク]
    O --> P[Slack通知: レビュー依頼]
    P --> Q[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。全ての操作はGitリポジトリとSlack APIを介して行われます。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TAG_1999 | タグエラー | 1.999.0タグがプッシュされた | タグを削除、正しいタグを再プッシュ |
| VERSION_MISMATCH | バージョンエラー | check-version.tsで不整合検出 | package.jsonとタグを確認 |
| CLONE_FAILED | Gitエラー | DefinitelyTypedクローン失敗 | ネットワーク確認、リトライ |
| PUSH_FAILED | Gitエラー | ブランチプッシュ失敗 | GITHUB_TOKEN権限確認 |
| SLACK_FAILED | 通知エラー | Slack API呼び出し失敗 | SLACK_TOKEN確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | - |
| リトライ対象エラー | 手動で再実行 |

### 障害時対応

1. 1.999.0タグの誤プッシュ時は、Slackの指示に従いタグを削除
2. バージョン不整合の場合、package.jsonとタグバージョンを確認
3. プッシュ失敗の場合、GITHUB_TOKENの権限を確認（DefinitelyTypedへの書き込み権限必要）
4. Slack通知失敗の場合、SLACK_TOKENの有効期限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Gitコミット単位 |
| コミットタイミング | 型定義更新完了後 |
| ロールバック条件 | プッシュ前のエラーは自動ロールバック、プッシュ後は手動でブランチ削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リリース/実行 |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | ubuntu-latestエージェント標準 |

## 排他制御

- 同一タグに対する重複実行は発生しない（タグプッシュトリガーのため）
- 同一バージョンのブランチが既に存在する場合、プッシュ時にエラー

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タグログ | タグ取得時 | タグバージョン |
| 差分ログ | git diff時 | 型定義ファイルの変更内容 |
| ステータスログ | git status時 | 変更ファイル一覧 |
| 通知ログ | Slack送信時 | 送信メッセージ概要 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 1.999.0タグ | 発生時 | Slack #C1C14HJ2F |
| パイプライン失敗 | 1回 | Azure DevOps通知 |

## 備考

- 1.999.0はVSCodeのテスト用バージョンであり、本番リリースには使用されない
- Slackチャンネル #C1C14HJ2F はVSCode開発チームの内部チャンネル
- PR作成リンクには自動的にPRテンプレートパラメータが含まれる（quick_pull=1&body=...）
- レビュー担当者は@jrieken, @kmaetzel, @egammaが指定されている
- DefinitelyTypedへのPRマージ後、npm publish --tag latestで@types/vscodeが公開される
- shallow clone (depth=1) によりクローン時間を短縮
