# バッチ設計書 50-sdl-scan-win32.yml

## 概要

本ドキュメントは、VS Code Windows版のSDL（Security Development Lifecycle）セキュリティスキャンパイプラインの設計仕様を定義するものです。Azure Pipelines上で実行され、APIScan、BinSkim、シンボル公開などのセキュリティ分析を実施します。

### 本バッチの処理概要

**業務上の目的・背景**：Microsoftのセキュリティ開発ライフサイクル（SDL）要件に準拠するため、VS Codeのバイナリに対してセキュリティ脆弱性スキャンを実施する必要があります。本バッチは、APIScanツールを使用してAPIの不正使用を検出し、シンボルファイルをTeam Foundation Server（TFS）に公開し、セキュリティログをTSA（Trust Services Automation）にアップロードします。

**バッチの実行タイミング**：product-buildパイプラインから呼び出され、Windowsビルド完了後にセキュリティ分析を実行します。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. 依存関係のインストール
3. ディストリビューション品質ミックスイン
4. TypeScriptコンパイル
5. Windowsシンボルのダウンロード
6. シンボルファイルの一覧表示
7. シンボルのAzure DevOpsアーティファクトへの公開
8. API Scanの収集準備
9. APIScanによるセキュリティスキャン実行
10. セキュリティ分析ログの公開
11. TSAへのセキュリティ結果アップロード

**前後の処理との関連**：Compilationジョブとproduct-build-win32ジョブの完了後に実行されます。シンボルはデバッグ目的でAzure DevOpsのシンボルサーバーに公開されます。

**影響範囲**：VS Code Windows版のセキュリティコンプライアンス、シンボルサーバーへのデバッグ情報公開に影響します。

## バッチ種別

セキュリティスキャン / コンプライアンス検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（CI/CD） |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 随時 |
| トリガー | パイプライントリガー（product-buildからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Azure Key Vault | github-distro-mixin-passwordシークレットが取得可能であること |
| APIScan | APIScanツールへのアクセス権があること |
| シンボルサーバー | symweb.azurefd.netへのアクセスが可能であること |
| TSA設定 | tsaoptions.jsonが正しく設定されていること |

### 実行可否判定

Windowsビルドが成功している場合にのみ実行されます。テストは含まれず、セキュリティスキャンのみを実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_ARCH | string | Yes | - | ターゲットアーキテクチャ（x64等） |
| VSCODE_QUALITY | string | Yes | - | 品質レベル（stable/insider） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | Git | VS Codeソースリポジトリ |
| Azure Key Vault | シークレット | github-distro-mixin-password |
| scanbin | ディレクトリ | スキャン対象バイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure DevOps Symbols | PDB | デバッグシンボル |
| CodeAnalysisLogs | 各種形式 | セキュリティ分析ログ |
| TSA | JSON | セキュリティ結果レポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CodeAnalysisLogs（複数ファイル） |
| 出力先 | パイプラインアーティファクト |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ ソースコードの取得
2. 環境セットアップ
   └─ Node.js、Python環境の準備
3. ディストリビューションダウンロード
   └─ 内部ディストリビューションの取得
4. Azure Key Vaultからシークレット取得
   └─ github-distro-mixin-password
5. NPMレジストリセットアップ
   └─ プライベートレジストリ設定
6. include.gypiファイル作成
   └─ デバッグ情報生成オプション設定
7. 依存関係インストール
   └─ npm ci実行（リトライ5回）
8. ディストリビューションミックスイン
   └─ npm modules、quality設定の適用
9. TypeScriptコンパイル
   └─ npm run compile
10. Windowsシンボルダウンロード
    └─ vscode-symbols-win32-$(VSCODE_ARCH)
11. シンボルファイル一覧表示
    └─ exe, dll, node, pdbファイル確認
12. シンボル公開
    └─ PublishSymbolsタスク実行
13. API Scan用シンボル収集
    └─ pdbファイルをsymbolsディレクトリに集約
14. APIScan実行
    └─ セキュリティ脆弱性スキャン
15. セキュリティ分析ログ公開
    └─ PublishSecurityAnalysisLogsタスク
16. TSAアップロード
    └─ セキュリティ結果をTSAに報告
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[チェックアウト・環境セットアップ]
    B --> C[Azure Key Vault シークレット取得]
    C --> D[NPMレジストリセットアップ]
    D --> E[include.gypi作成]
    E --> F[npm ci実行]
    F --> G[ディストリビューションミックスイン]
    G --> H[TypeScriptコンパイル]
    H --> I[Windowsシンボルダウンロード]
    I --> J[シンボルファイル一覧表示]
    J --> K[シンボルをAzure DevOpsに公開]
    K --> L[API Scan用シンボル収集]
    L --> M[APIScan実行]
    M --> N[セキュリティ分析ログ公開]
    N --> O[TSAアップロード]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません（Azure DevOpsシンボルサーバーへの書き込みあり）。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| シンボル公開 | Azure DevOps Symbols | INSERT | デバッグシンボルの登録 |
| TSAアップロード | TSA DB | INSERT | セキュリティ結果の登録 |

### テーブル別操作詳細

#### Azure DevOps Symbols

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | PDBファイル | scanbin配下の*.pdb | vscode-clientとして登録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| npm ci失敗 | 依存関係エラー | npm registry接続不可 | 最大5回リトライ |
| APIScan失敗 | スキャンエラー | バイナリ形式エラー/接続エラー | ログ確認、再実行 |
| シンボル公開失敗 | Azure DevOpsエラー | 認証エラー/ストレージエラー | 接続設定確認 |
| TSAアップロード失敗 | TSAエラー | 設定ファイルエラー | tsaoptions.json確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、Policy DTO copy: 3回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm install失敗 |

### 障害時対応

1. ログ確認: Azure Pipelinesのジョブログを確認
2. APIScanエラー: セキュリティログを確認
3. TSAエラー: tsaoptions.json設定確認
4. 手動再実行: パイプラインを再実行（continueOnError: trueのため部分的に継続）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各タスク単位 |
| コミットタイミング | タスク完了時 |
| ロールバック条件 | TSAアップロードはcontinueOnError: trueで失敗を許容 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1スキャン/実行 |
| 目標処理時間 | タイムアウト設定なし（デフォルト） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

同一パイプライン内での重複実行は行いません。シンボルサーバーへの公開は追加操作です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| 進捗ログ | 各ステップ完了時 | ステップ名、所要時間 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| セキュリティログ | APIScan完了時 | 検出された脆弱性情報 |
| シンボル一覧 | シンボルダウンロード後 | exe, dll, node, pdbファイルリスト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| APIScan脆弱性検出 | 重大度High以上 | TSA経由で通知 |
| ビルド失敗 | 1回 | パイプライン通知 |

## 備考

- APIScan設定:
  - softwareFolder: $(Agent.BuildDirectory)\scanbin
  - softwareName: vscode-client
  - softwareVersionNum: 1
  - symbolsFolder: symweb.azurefd.net + ローカルシンボル
- include.gypi: MSVCコンパイラオプションでデバッグ情報（/Zi, /FS）とプロファイル情報（/profile）を有効化
- シンボルサーバー: symweb.azurefd.net（Microsoft社内シンボルサーバー）
- TSA設定ファイル: build/azure-pipelines/config/tsaoptions.json
- AzureServicesAuthConnectionString: サービスプリンシパル認証情報（AppId、TenantId、ServiceConnectionId）
- TSAアップロードはcontinueOnError: trueで、失敗してもパイプラインは継続します
- PublishSecurityAnalysisLogs: AllTools設定で全セキュリティツールのログを公開
