# バッチ設計書 6-distro-build

## 概要

本ドキュメントは、Visual Studio Codeのディストリビューションビルドパイプライン「distro-build」の設計仕様を定義するものです。各プラットフォーム向けのdistro（配布用カスタマイズ）をダウンロードするための基盤パイプラインを担当します。

### 本バッチの処理概要

本バッチは、VSCodeのディストリビューションビルドの基盤となるパイプラインです。microsoft/vscode-distroリポジトリからプラットフォーム固有の設定やアセットをダウンロードし、後続のプラットフォーム別ビルドで使用可能な状態にします。

**業務上の目的・背景**：VSCodeは、オープンソースのCode - OSSをベースに、Microsoft固有のブランディング、テレメトリ設定、ライセンス情報などを追加してVisual Studio Codeとしてリリースされます。本バッチは、このdistro（ディストリビューション）情報を取得し、ビルドプロセスに統合するための基盤を提供します。これにより、公式VSCode製品とCode - OSSの分離が維持されつつ、効率的なビルドプロセスが実現されています。

**バッチの実行タイミング**：mainまたはrelease/*ブランチへのプッシュ時に自動実行されます。他のビルドパイプラインから参照されるテンプレートとしても使用されます。

**主要な処理内容**：
1. Node.jsのセットアップ
2. distroダウンロードテンプレートの実行

**前後の処理との関連**：本バッチで準備されたdistro情報は、product-compile、product-build、および各プラットフォーム固有のビルドパイプラインで使用されます。download-distro.ymlテンプレートは多くのパイプラインから参照されています。

**影響範囲**：ビルドエージェントのローカルファイルシステム（.build/distro/）、後続の全プラットフォームビルドステージに影響します。

## バッチ種別

CI/CDパイプライン（ビルド準備）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ブランチプッシュ時 |
| 実行時刻 | プッシュのタイミング |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | main/release/* ブランチへのプッシュ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | main または release/* ブランチであること |
| ビルドエージェント | 1es-ubuntu-22.04-x64 プールが利用可能 |
| 認証情報 | microsoft/vscode-distroリポジトリへのアクセス権限 |

### 実行可否判定

- pr: noneにより、Pull Requestでは実行されない
- mainまたはrelease/*ブランチへのプッシュのみトリガー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | 本バッチでは入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub microsoft/vscode | Git Repository | メインソースコード |
| GitHub microsoft/vscode-distro | Git Repository | ディストリビューション設定（プライベート） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .build/distro/ | ディレクトリ | ダウンロードされたdistroファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | distro関連ファイル群 |
| 出力先 | .build/distro/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
2. distroダウンロード
   └─ distro/download-distro.ymlテンプレート実行
```

### フローチャート

```mermaid
flowchart TD
    A[パイプライン開始] --> B[Node.jsセットアップ]
    B --> C[download-distro.yml実行]
    C --> D[.build/distro/に出力]
    D --> E[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。全ての操作はファイルシステムを介して行われます。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NODE_SETUP_FAILED | セットアップエラー | Node.jsインストール失敗 | エージェント環境確認 |
| DISTRO_DOWNLOAD_FAILED | ダウンロードエラー | vscode-distroアクセス失敗 | 認証情報確認、ネットワーク確認 |
| AUTH_FAILED | 認証エラー | プライベートリポジトリアクセス拒否 | GITHUB_TOKEN権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | - |
| リトライ対象エラー | 手動で再実行 |

### 障害時対応

1. ダウンロード失敗の場合、microsoft/vscode-distroリポジトリの状態を確認
2. 認証エラーの場合、GITHUB_TOKENの権限を確認
3. ネットワークエラーの場合、Azure DevOpsエージェントの接続状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | パイプライン全体 |
| コミットタイミング | 成功時のみ成果物が有効 |
| ロールバック条件 | 失敗時は成果物なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ダウンロード/実行 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

- 同一ビルド内での重複実行なし
- 複数ビルドでの並列実行は可能（各ビルドで独立したワークスペース）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | パイプライン開始時 | ブランチ名、コミットID |
| セットアップログ | Node.jsセットアップ時 | Node.jsバージョン |
| ダウンロードログ | distroダウンロード時 | ダウンロード進捗 |
| 完了ログ | パイプライン完了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| パイプライン失敗 | 1回 | Azure DevOps通知 |
| 処理時間 | 5分超過 | ビルドログ |

## 備考

- Linuxエージェント（1es-ubuntu-22.04-x64）で実行
- microsoft/vscode-distroはプライベートリポジトリのため、認証が必要
- download-distro.ymlテンプレートは他のパイプラインからも参照される共通コンポーネント
- distro情報には、ブランディング、テレメトリ設定、ライセンス情報などが含まれる
- Code - OSS（オープンソース版）とVSCode（製品版）の違いは主にdistroで定義される
