# バッチ設計書 7-pr.yml

## 概要

本ドキュメントは、Visual Studio Codeのプルリクエスト検証ワークフロー「pr.yml」の設計仕様を定義するものです。GitHub Actionsで実行され、PRに対するコンパイル、Hygiene、各種テストを包括的に実行します。

### 本バッチの処理概要

本バッチは、VSCodeリポジトリへのPull Request時に自動実行されるGitHub Actionsワークフローです。コンパイル、Hygieneチェック、Linuxでのユニットテスト・統合テスト・スモークテスト、macOSでのテスト、Windowsでのテストを並列で実行し、コード品質を検証します。

**業務上の目的・背景**：VSCodeは大規模なオープンソースプロジェクトであり、多数のコントリビューターからのPRを受け付けています。本バッチにより、PRがマージされる前にコードの品質、テストの成功、コーディング規約への準拠を自動的に検証し、mainブランチの品質を維持します。Code - OSS（オープンソース版）としてのビルドとテストが実行されます。

**バッチの実行タイミング**：main または release/* ブランチへのPull Request作成・更新時に自動実行されます。

**主要な処理内容**：
1. Compile & Hygieneジョブ
   - ソースコードのコンパイル
   - 拡張機能のコンパイル
   - Hygieneチェック、ESLint、各種検証
2. Linux CLIテストジョブ
   - Rust CLIのテスト
3. Linuxテストジョブ（3種類並列）
   - Electronテスト
   - Browserテスト
   - Remoteテスト
4. macOSテストジョブ（3種類並列）
   - Electronテスト
   - Browserテスト
   - Remoteテスト
5. Windowsテストジョブ（3種類並列）
   - Electronテスト
   - Browserテスト
   - Remoteテスト

**前後の処理との関連**：本バッチはPRの検証に特化しており、製品ビルド（product-build）とは独立しています。PRがマージされると、product-buildパイプラインがトリガーされます。

**影響範囲**：GitHub PRステータス、GitHub Actions実行ログに影響します。製品ビルドやリリースには直接影響しません。

## バッチ種別

GitHub Actions（CI検証ワークフロー）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PRイベント時 |
| 実行時刻 | PR作成・更新のタイミング |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | main/release/* ブランチへのPull Request |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PRターゲット | main または release/* ブランチへのPRであること |
| ビルドエージェント | 1es-vscode-oss-ubuntu-22.04-x64 (Linux)、他プラットフォーム用エージェント |
| GITHUB_TOKEN | シークレットとして設定されていること |

### 実行可否判定

- concurrency設定により、同一PRに対する複数の同時実行はキャンセルされる
- cancel-in-progress: true により、新しい実行が開始されると古い実行はキャンセル

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | 本ワークフローでは明示的な入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Pull Request | Git | PRのソースブランチ |
| GitHub Secrets | Secret | GITHUB_TOKEN |
| node_modulesキャッシュ | tar.gz | 以前のビルドからのキャッシュ |
| builtInExtensionsキャッシュ | ディレクトリ | 組み込み拡張機能キャッシュ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR Status | ステータス | 各ジョブの成功/失敗 |
| GitHub Actions Artifacts | 各種 | クラッシュダンプ、ログ（失敗時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | crash-dump-*, logs-*, node-modules-*（失敗時のみ） |
| 出力先 | GitHub Actions Artifacts |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. compileジョブ（Compile & Hygiene）
   └─ チェックアウト → Node.js設定 → キャッシュ復元
   └─ npm ci → コンパイル → Hygiene/ESLint
2. linux-cli-testsジョブ（並列）
   └─ pr-linux-cli-test.yml呼び出し（Rust CLI テスト）
3. linux-electron-testsジョブ（並列）
   └─ pr-linux-test.yml呼び出し（electron_tests: true）
4. linux-browser-testsジョブ（並列）
   └─ pr-linux-test.yml呼び出し（browser_tests: true）
5. linux-remote-testsジョブ（並列）
   └─ pr-linux-test.yml呼び出し（remote_tests: true）
6. macos-electron-testsジョブ（並列）
   └─ pr-darwin-test.yml呼び出し（electron_tests: true）
7. macos-browser-testsジョブ（並列）
   └─ pr-darwin-test.yml呼び出し（browser_tests: true）
8. macos-remote-testsジョブ（並列）
   └─ pr-darwin-test.yml呼び出し（remote_tests: true）
9. windows-electron-testsジョブ（並列）
   └─ pr-win32-test.yml呼び出し（electron_tests: true）
10. windows-browser-testsジョブ（並列）
    └─ pr-win32-test.yml呼び出し（browser_tests: true）
11. windows-remote-testsジョブ（並列）
    └─ pr-win32-test.yml呼び出し（remote_tests: true）
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新] --> B{同時実行中?}
    B -->|Yes| C[既存実行キャンセル]
    B -->|No| D[ワークフロー開始]
    C --> D
    D --> E[Compile & Hygiene]
    D --> F[Linux CLI Tests]
    D --> G[Linux Electron Tests]
    D --> H[Linux Browser Tests]
    D --> I[Linux Remote Tests]
    D --> J[macOS Electron Tests]
    D --> K[macOS Browser Tests]
    D --> L[macOS Remote Tests]
    D --> M[Windows Electron Tests]
    D --> N[Windows Browser Tests]
    D --> O[Windows Remote Tests]
    E --> P{全ジョブ完了?}
    F --> P
    G --> P
    H --> P
    I --> P
    J --> P
    K --> P
    L --> P
    M --> P
    N --> P
    O --> P
    P -->|Yes| Q[PR Status更新]
    Q --> R[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。全ての操作はファイルシステムとGitHub APIを介して行われます。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| COMPILE_FAILED | コンパイルエラー | TypeScriptコンパイル失敗 | PRのコードを修正 |
| HYGIENE_FAILED | 品質エラー | Hygiene/ESLint違反 | コーディング規約に従い修正 |
| TEST_FAILED | テストエラー | ユニット/統合/スモークテスト失敗 | テストを修正またはコードを修正 |
| TIMEOUT | タイムアウト | 処理時間超過 | 処理の最適化または再実行 |
| CACHE_MISS | キャッシュエラー | キャッシュ復元失敗 | 自動的にフルインストール実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、Electron/Playwright DL: 3回 |
| リトライ間隔 | 即時（npm ci）、5秒（DL） |
| リトライ対象エラー | ネットワーク関連の一時的エラー |

### 障害時対応

1. コンパイル/Hygieneエラーの場合、ローカルで`npm run compile`と`npm run hygiene`を実行して確認
2. テストエラーの場合、ログからテスト失敗の詳細を確認
3. クラッシュ発生時は、Artifactとしてアップロードされたクラッシュダンプを分析
4. 一時的なインフラエラーの場合、ワークフローを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ単位 |
| コミットタイミング | 各ジョブ完了時にステータス更新 |
| ロールバック条件 | ジョブ失敗時はPRステータスをfailureに |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1PR/実行 |
| 目標処理時間 | Compile: 制限なし、各テスト: 15-30分 |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

- concurrency設定により、同一ワークフロー・同一PR refに対する重複実行を制御
- cancel-in-progress: true により、新しい実行が優先される
- 異なるPRは並列実行可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | PR番号、ブランチ名 |
| キャッシュログ | キャッシュ処理時 | ヒット/ミス情報 |
| コンパイルログ | コンパイル時 | TypeScript出力 |
| テストログ | テスト実行時 | テスト結果、失敗詳細 |
| 診断ログ | スモークテスト前後 | プロセス一覧、ファイルハンドル数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHub PRステータス |
| テストタイムアウト | 各テスト15-30分 | GitHub Actions |

## 備考

- VSCODE_QUALITY: 'oss' として実行（オープンソース版ビルド）
- permissions: {} により、最小権限で実行（セキュリティ対策）
- 再利用可能ワークフロー（pr-linux-test.yml等）を使用してDRY原則を維持
- rustup_toolchain: 1.85 でRust CLIテストを実行
- Self-hostedランナー（1es-vscode-oss-ubuntu-22.04-x64）を使用
- ELECTRON_SKIP_BINARY_DOWNLOAD=1, PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1でコンパイル時間を短縮
