# バッチ設計書 8-monaco-editor.yml

## 概要

本ドキュメントは、Monaco Editorチェックワークフロー「monaco-editor.yml」の設計仕様を定義するものです。GitHub Actionsで実行され、Monaco Editorのビルド、テスト、型定義検証を包括的に実行します。

### 本バッチの処理概要

本バッチは、VSCodeのコアエディタコンポーネントであるMonaco Editorの品質を検証するGitHub Actionsワークフローです。push/PR時に、Monaco Editorのコンパイルチェック、ESMビルド、型定義検証、Webpackパッケージング、テストを実行します。

**業務上の目的・背景**：Monaco EditorはVSCodeのテキストエディタ部分を独立したライブラリとして提供しており、多くのWebアプリケーションで使用されています。本バッチにより、VSCodeへの変更がMonaco Editorの互換性を損なわないことを継続的に検証し、Monaco Editorを利用する外部開発者への影響を最小限に抑えます。

**バッチの実行タイミング**：main または release/* ブランチへのpushまたはPull Request時に自動実行されます。

**主要な処理内容**：
1. 依存関係のインストールとキャッシュ
2. Playwrightのダウンロード
3. Monaco Editorコンパイルチェック（monaco-compile-check）
4. Editor Distro & ESMビルド（editor-distro）
5. ESMソースチェック
6. 型定義（Typings）検証
7. Webpackによるパッケージング検証
8. Editorテストのコンパイルと実行

**前後の処理との関連**：本バッチはMonaco Editor固有の検証に特化しており、他のCIワークフローとは独立しています。VSCodeのPRワークフロー（pr.yml）とは別に実行されます。

**影響範囲**：GitHub PRステータス、Monaco Editorのビルド互換性に影響します。

## バッチ種別

GitHub Actions（CI検証ワークフロー）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | push/PRイベント時 |
| 実行時刻 | イベント発生のタイミング |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | main/release/* ブランチへのpush/PR |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ターゲットブランチ | main または release/* ブランチ |
| ビルドエージェント | ubuntu-latest |
| GITHUB_TOKEN | シークレットとして設定されていること |

### 実行可否判定

- pushとpull_request両方のイベントでトリガー
- permissions: {} により最小権限で実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | 本ワークフローでは明示的な入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Repository | Git | ソースコード |
| GitHub Secrets | Secret | GITHUB_TOKEN |
| node_modulesキャッシュ | ディレクトリ | 以前のビルドからのキャッシュ |
| npmキャッシュ | ディレクトリ | npmキャッシュディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR Status | ステータス | ジョブの成功/失敗 |
| out-monaco-editor-core/ | ディレクトリ | ビルドされたMonaco Editor |
| typings-test/ | ディレクトリ | 型定義検証用一時ディレクトリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | out-monaco-editor-core/（ビルド成果物） |
| 出力先 | ワークスペース内 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ actions/checkout@v6（persist-credentials: false）
2. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
3. node_modulesキャッシュキー計算
   └─ computeNodeModulesCacheKey.ts実行
4. node_modulesキャッシュ復元
   └─ actions/cache@v5使用
5. npmキャッシュディレクトリ取得（キャッシュミス時）
   └─ npm config get cache
6. npmディレクトリキャッシュ（キャッシュミス時）
   └─ actions/cache@v5使用
7. システム依存関係インストール（キャッシュミス時）
   └─ libxkbfile-dev, pkg-config, libkrb5-dev, libxss1
8. npm ci実行（キャッシュミス時）
   └─ ELECTRON/PLAYWRIGHT_SKIP_BINARY_DOWNLOAD=1
9. Playwrightダウンロード
   └─ npm run playwright-install
10. Monaco Editorコンパイルチェック
    └─ npm run monaco-compile-check
11. Editor Distro & ESM
    └─ npm run gulp editor-distro
12. ESMソースチェック
    └─ test/monaco: npm run esm-check
13. 型定義検証準備
    └─ mkdir typings-test
14. 型定義検証
    └─ npm init → tsc --init → a.ts作成 → tsc --noEmit
15. Webpackパッケージング
    └─ test/monaco: npm run bundle-webpack
16. Editorテストコンパイル
    └─ test/monaco: npm run compile
17. Editorテスト実行（タイムアウト5分）
    └─ test/monaco: npm run test
```

### フローチャート

```mermaid
flowchart TD
    A[push/PR トリガー] --> B[チェックアウト]
    B --> C[Node.jsセットアップ]
    C --> D[キャッシュキー計算]
    D --> E{node_modulesキャッシュヒット?}
    E -->|Yes| F[Playwrightダウンロード]
    E -->|No| G[npm ci実行]
    G --> F
    F --> H[monaco-compile-check]
    H --> I[editor-distro]
    I --> J[ESMソースチェック]
    J --> K[型定義検証]
    K --> L[Webpackパッケージング]
    L --> M[Editorテストコンパイル]
    M --> N[Editorテスト実行]
    N --> O{全て成功?}
    O -->|Yes| P[成功]
    O -->|No| Q[失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MONACO_COMPILE_FAILED | コンパイルエラー | Monaco固有コンパイル失敗 | エラーメッセージに従い修正 |
| EDITOR_DISTRO_FAILED | ビルドエラー | ESMビルド失敗 | gulpタスクのエラーを確認 |
| ESM_CHECK_FAILED | 検証エラー | ESMソース不整合 | モジュール構造を確認 |
| TYPINGS_FAILED | 型エラー | 型定義不整合 | d.tsファイルを確認 |
| WEBPACK_FAILED | パッケージングエラー | Webpackバンドル失敗 | バンドル設定を確認 |
| TEST_FAILED | テストエラー | Editorテスト失敗 | テストログを確認 |
| TEST_TIMEOUT | タイムアウト | テスト5分超過 | テストの最適化 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | - |
| リトライ対象エラー | 手動で再実行 |

### 障害時対応

1. monaco-compile-checkエラー時は、Monaco固有のAPI互換性を確認
2. editor-distroエラー時は、gulpタスクのログを確認
3. 型定義エラー時は、vscode.d.tsの変更を確認
4. テストタイムアウト時は、テストの実行時間を分析

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ全体 |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | 任意のステップ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 40分以内（timeout-minutes: 40） |
| メモリ使用量上限 | ubuntu-latest標準 |

## 排他制御

- 同一ワークフローの並列実行は許可（concurrency設定なし）
- 各実行は独立したワークスペースで実行

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| キャッシュログ | キャッシュ処理時 | ヒット/ミス情報 |
| コンパイルログ | コンパイル時 | TypeScript出力 |
| ESMログ | ESMチェック時 | モジュール検証結果 |
| 型検証ログ | 型定義検証時 | tscエラー/成功 |
| テストログ | テスト実行時 | テスト結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHub PRステータス |
| ジョブタイムアウト | 40分 | GitHub Actions |
| テストタイムアウト | 5分 | テストステップ |

## 備考

- persist-credentials: false でチェックアウト（セキュリティ対策）
- ELECTRON_SKIP_BINARY_DOWNLOAD=1, PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1 で初期インストール高速化
- 型定義検証では、動的にtypings-testディレクトリを作成し、実際にimportしてtscでチェック
- test/monaco配下のEditorテストは、Playwright（ブラウザ）を使用
- キャッシュキーにはOS情報（${{ runner.os }}）が含まれる
- restore-keysにより、部分一致でもキャッシュ復元を試行
