# バッチ設計書 9-telemetry.yml

## 概要

本ドキュメントは、テレメトリメタデータチェックワークフロー「telemetry.yml」の設計仕様を定義するものです。GitHub Actionsで実行され、PR時にvscode-telemetry-extractorを使用してテレメトリイベントのメタデータを検証します。

### 本バッチの処理概要

本バッチは、VSCodeのテレメトリ（利用統計）イベントの定義が正しく記述されているかを検証するGitHub Actionsワークフローです。@vscode/telemetry-extractorツールを使用して、ソースコード内のテレメトリイベント定義を抽出し、メタデータの整合性をチェックします。

**業務上の目的・背景**：VSCodeはユーザーの利用状況を把握するためにテレメトリを収集しています。テレメトリイベントは適切に定義・文書化される必要があり、定義の不整合や漏れがあると、データ分析に支障をきたしたり、プライバシーポリシーとの整合性に問題が生じる可能性があります。本バッチにより、PRの段階でテレメトリ定義の品質を自動検証し、問題を早期に検出します。

**バッチの実行タイミング**：Pull Request作成・更新時に自動実行されます。

**主要な処理内容**：
1. ソースコードのチェックアウト
2. Node.jsのセットアップ
3. vscode-telemetry-extractor@1.14.0の実行

**前後の処理との関連**：本バッチはPR検証の一部として、他のCIワークフローと並列で実行されます。テレメトリ定義の変更がある場合に特に重要です。

**影響範囲**：GitHub PRステータスに影響します。テレメトリ定義の品質管理に寄与します。

## バッチ種別

GitHub Actions（CI検証ワークフロー）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PRイベント時 |
| 実行時刻 | PR作成・更新のタイミング |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | Pull Request |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| イベント | Pull Requestであること |
| ビルドエージェント | ubuntu-latest |
| GITHUB_TOKEN | シークレットとして設定されていること |

### 実行可否判定

- すべてのPRに対して実行（ブランチフィルタなし）
- permissions: {} により最小権限で実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | 本ワークフローでは明示的な入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Pull Request | Git | PRのソースブランチ |
| GitHub Secrets | Secret | GITHUB_TOKEN |
| npm Registry | Package | @vscode/telemetry-extractor@1.14.0 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR Status | ステータス | ジョブの成功/失敗 |
| 標準出力 | テキスト | テレメトリ抽出結果 |

### 出力ファイル仕様

本バッチではファイル出力は行いません。検証結果は標準出力とGitHub PRステータスに反映されます。

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ actions/checkout@v6（persist-credentials: false）
2. Node.jsセットアップ
   └─ node-version: 'lts/*'（最新LTS）
3. vscode-telemetry-extractor実行
   └─ npx --package=@vscode/telemetry-extractor@1.14.0 --yes vscode-telemetry-extractor -s .
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新] --> B[チェックアウト]
    B --> C[Node.js LTSセットアップ]
    C --> D[vscode-telemetry-extractor実行]
    D --> E{抽出成功?}
    E -->|Yes| F[PRステータス: 成功]
    E -->|No| G[PRステータス: 失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EXTRACTOR_FAILED | 抽出エラー | テレメトリ定義の不整合 | エラーメッセージに従いテレメトリ定義を修正 |
| NPX_FAILED | 実行エラー | npxコマンド失敗 | ネットワーク確認、npm registry確認 |
| CHECKOUT_FAILED | チェックアウトエラー | リポジトリアクセス失敗 | 権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | - |
| リトライ対象エラー | 手動で再実行 |

### 障害時対応

1. テレメトリ定義エラーの場合、vscode-telemetry-extractorの出力を確認
2. テレメトリイベントの定義形式を確認（JSDoc形式等）
3. 類似の既存定義を参考に修正
4. ローカルで`npx @vscode/telemetry-extractor -s .`を実行して事前確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ全体 |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | 任意のステップ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1PR/実行 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | ubuntu-latest標準 |

## 排他制御

- 同一ワークフローの並列実行は許可
- 各実行は独立したワークスペースで実行

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | PR番号 |
| 抽出ログ | extractor実行時 | 抽出されたテレメトリイベント一覧 |
| エラーログ | エラー発生時 | 定義エラーの詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHub PRステータス |

## 備考

- @vscode/telemetry-extractor のバージョンは1.14.0に固定（互換性維持のため）
- `--yes`フラグによりnpxのプロンプトをスキップ
- `-s .`オプションでカレントディレクトリ（リポジトリルート）を対象にスキャン
- persist-credentials: false でセキュリティを強化
- Node.jsバージョンは'lts/*'で最新LTSを使用（他のワークフローと異なる）
- シンプルなワークフローのため、キャッシュは使用していない
- テレメトリ定義はJSDocコメント形式で記述され、extractorがそれを解析
