---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-product-build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Slack通知先チャンネル**：ソースコード内に直接的な記載なし
  2. **処理時間の閾値**：運用要件として推測
  3. **テスト失敗率の閾値**：運用要件として推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/product-build.yml` (L1-520)
- E-02: `build/azure-pipelines/product-compile.yml` (L1-172)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L2)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 月〜金 7:00/19:00に定期実行 | E-01 L3-13 (schedules設定) | ○ |
| C-02 | main/release/*ブランチがトリガー対象 | E-01 L15-18 (trigger設定) | ○ |
| C-03 | VSCODE_QUALITYパラメータでinsider/stable等を指定 | E-01 L21-28 (parameters) | ○ |
| C-04 | 各プラットフォームビルドフラグが存在 | E-01 L37-84 (parameters) | ○ |
| C-05 | batch: trueで複数コミットをバッチ処理 | E-01 L16 (batch: true) | ○ |
| C-06 | Compileステージがパイプラインの最初 | E-01 L197-202 (stages) | ○ |
| C-07 | CompileCLIステージで各プラットフォームCLIをビルド | E-01 L204-263 (CompileCLI stage) | ○ |
| C-08 | 1ESPipelineTemplatesを使用 | E-01 L166-172 (extends) | ○ |
| C-09 | Azure Key Vaultからシークレット取得 | E-02 L22-28 (AzureKeyVault task) | ○ |
| C-10 | npm ciを5回リトライ | E-02 L63-79 (retry loop) | ○ |
| C-11 | Compileステージタイムアウト60分 | E-02 L3 (timeoutInMinutes: 60) | ○ |
| C-12 | compilation.tar.gzとして成果物出力 | E-02 L7-8 (artifact output) | ○ |
| C-13 | ESRP署名用認証情報を使用 | E-01 L136-144 (ESRP variables) | ○ |
| C-14 | Component Detection実施 | E-02 L166-171 (ComponentGovernance task) | ○ |
| C-15 | SDLスキャンが有効 | E-01 L174-192 (sdl configuration) | ○ |
| C-16 | PublishステージでreleaseBuild.ts実行 | E-01 L483-491 (Publish stage) | ○ |
| C-17 | PRSS CDN URLはvscode.download.prss.microsoft.com | E-01 L134 (PRSS_CDN_URL) | ○ |
| C-18 | Azure Cosmos DB endpointはvscode.documents.azure.com | E-01 L146 (AZURE_DOCUMENTDB_ENDPOINT) | ○ |
| C-19 | Windowsステージで各種テスト実行 | E-01 L305-354 (Windows stage) | ○ |
| C-20 | macOSでUniversal Binary対応 | E-01 L467-468 (darwin-universal.yml) | ○ |
| C-21 | Web版ビルドステージ存在 | E-01 L476-481 (Web stage) | ○ |
| C-22 | ApproveReleaseステージで承認処理 | E-01 L492-504 (ApproveRelease stage) | ○ |
| C-23 | VS Code 7PM Kick-Offパイプラインからトリガー | E-01 L162-164 (pipeline trigger) | ○ |
| C-24 | 成果物処理で3回リトライ | product-publish.yml L110 (retryCountOnTaskFailure: 3) | ○ |
| C-25 | #vscode-build Slackチャンネルに通知 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Slack通知先チャンネル名は推測に基づく（publish-types.ymlに類似のSlack通知があるが、product-buildでの通知先は明示されていない）
  - 候補：Azure DevOps通知 / Teams連携 / 別途運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 技術仕様は全てソースコードから確認可能
- 1: 中リスク - 運用監視の閾値や通知先は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] スケジュール設定（7:00/19:00）が運用要件と一致するか確認
- [ ] 各プラットフォームビルドフラグのデフォルト値が適切か確認
- [ ] 障害時の通知先・エスカレーション先を運用チームに確認
- [ ] タイムアウト値（60分/180分）が実運用と整合するか確認
