---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-pr-linux-test.yml

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/pr-linux-test.yml` (L1-288)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L11)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | on: workflow_callでトリガー | E-01 L1 (on: workflow_call) | ○ |
| C-02 | job_nameパラメータ（string, required） | E-01 L3-5 (inputs: job_name) | ○ |
| C-03 | electron_testsパラメータ（boolean, default: false） | E-01 L6-8 (inputs: electron_tests) | ○ |
| C-04 | browser_testsパラメータ（boolean, default: false） | E-01 L9-11 (inputs: browser_tests) | ○ |
| C-05 | remote_testsパラメータ（boolean, default: false） | E-01 L12-15 (inputs: remote_tests) | ○ |
| C-06 | ジョブ名は${{ inputs.job_name }} | E-01 L19 (name) | ○ |
| C-07 | self-hostedランナー使用 | E-01 L20 (runs-on: self-hosted) | ○ |
| C-08 | 1es-vscode-oss-ubuntu-22.04-x64プール | E-01 L20 (Pool名) | ○ |
| C-09 | ARTIFACT_NAME環境変数の条件設定 | E-01 L22 (env: ARTIFACT_NAME) | ○ |
| C-10 | NPM_ARCH, VSCODE_ARCHはx64 | E-01 L23-24 (env) | ○ |
| C-11 | xvfb等システム依存関係インストール | E-01 L35-49 (apt-get install) | ○ |
| C-12 | xvfb.initをコピー・設定 | E-01 L46-48 (xvfb setup) | ○ |
| C-13 | computeNodeModulesCacheKey.ts linux使用 | E-01 L52 (cacheKey計算) | ○ |
| C-14 | npm ciを5回リトライ | E-01 L66-78, L82-96 (for i in {1..5}) | ○ |
| C-15 | listNodeModules.tsでアーカイブ作成 | E-01 L104-110 (node_modules archive) | ○ |
| C-16 | computeBuiltInDepsCacheKey.tsでキャッシュキー計算 | E-01 L116 (builtindepshash) | ○ |
| C-17 | enableCrossOsArchive: true設定 | E-01 L122 (cache設定) | ○ |
| C-18 | builtInExtensions.tsでダウンロード | E-01 L128 (download) | ○ |
| C-19 | transpile-client-esbuild transpile-extensions実行 | E-01 L133 (gulp) | ○ |
| C-20 | Electron/Playwrightダウンロード3回リトライ | E-01 L135-152 (for i in {1..3}) | ○ |
| C-21 | Electronユニットテスト15分タイムアウト | E-01 L156-159 (timeout-minutes: 15) | ○ |
| C-22 | Browserユニットテスト30分タイムアウト | E-01 L168-171 (timeout-minutes: 30) | ○ |
| C-23 | 統合テストビルドで複数拡張機能コンパイル | E-01 L175-195 (compile-extension:*) | ○ |
| C-24 | 各統合テスト20分タイムアウト | E-01 L197-212 (timeout-minutes: 20) | ○ |
| C-25 | スモークテストで--tracingオプション | E-01 L232-248 (--tracing) | ○ |
| C-26 | 診断情報出力（ps, max_user_watches, lsof） | E-01 L223-230, L250-258 (diagnostics) | ○ |
| C-27 | 失敗時クラッシュダンプアップロード | E-01 L260-268 (upload-artifact crash) | ○ |
| C-28 | 失敗時ログアップロード（always） | E-01 L280-288 (upload-artifact logs) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がpr-linux-test.ymlから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] self-hostedランナー（1es-vscode-oss-ubuntu-22.04-x64）の可用性を確認
- [ ] 各テストのタイムアウト設定が実際の実行時間と整合するか確認
- [ ] xvfbサービスの設定が最新要件と一致するか確認
- [ ] 統合テストでコンパイルする拡張機能リストが最新か確認
