---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-pr-darwin-test.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間30-60分**：推定値のため要確認
  2. **GYP_DEFINESの目的説明**：コメントに基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/pr-darwin-test.yml`（行1-242）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行12）
- E-03: `.github/workflows/pr-darwin-test.yml`（行20：runs-on: macos-14-xlarge）
- E-04: `.github/workflows/pr-darwin-test.yml`（行23-24：NPM_ARCH, VSCODE_ARCH）
- E-05: `.github/workflows/pr-darwin-test.yml`（行56-63：npm ciリトライロジック）
- E-06: `.github/workflows/pr-darwin-test.yml`（行111-123：Electronダウンロードリトライ）
- E-07: `.github/workflows/pr-darwin-test.yml`（行129-140：テスト実行条件）
- E-08: `.github/workflows/pr-darwin-test.yml`（行74：GYP_DEFINES設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workflow_callで呼び出される再利用可能ワークフロー | E-01 (line 2) | ○ |
| C-02 | macos-14-xlargeランナーで実行 | E-03 | ○ |
| C-03 | arm64アーキテクチャで実行 | E-04 | ○ |
| C-04 | job_name入力パラメータが必須 | E-01 (line 4-6) | ○ |
| C-05 | electron_testsはデフォルトfalse | E-01 (line 7-9) | ○ |
| C-06 | browser_testsはデフォルトfalse | E-01 (line 10-12) | ○ |
| C-07 | remote_testsはデフォルトfalse | E-01 (line 13-15) | ○ |
| C-08 | npm ci最大5回リトライ | E-05 | ○ |
| C-09 | Electronダウンロード最大3回リトライ | E-06 | ○ |
| C-10 | Webkitブラウザでテスト実行 | E-01 (line 141, 175) | ○ |
| C-11 | ユニットテスト15分タイムアウト | E-01 (line 131, 136) | ○ |
| C-12 | 統合テスト20分タイムアウト | E-01 (line 169) | ○ |
| C-13 | スモークテスト20分タイムアウト | E-01 (line 198) | ○ |
| C-14 | クラッシュレポートをartifactとしてアップロード | E-01 (line 214-221) | ○ |
| C-15 | ログファイルをartifactとしてアップロード | E-01 (line 234-241) | ○ |
| C-16 | node_modulesキャッシュを使用 | E-01 (line 38-46) | ○ |
| C-17 | built-in extensionsキャッシュを使用 | E-01 (line 90-96) | ○ |
| C-18 | transpile-client-esbuildを実行 | E-01 (line 105) | ○ |
| C-19 | ELECTRON_SKIP_BINARY_DOWNLOAD=1を設定 | E-01 (line 67) | ○ |
| C-20 | PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1を設定 | E-01 (line 68) | ○ |
| C-21 | GYP_DEFINESでkerberos_use_rtld=false設定 | E-08 | ○ |
| C-22 | test.shでユニットテスト実行 | E-01 (line 131) | ○ |
| C-23 | test-integration.shで統合テスト実行 | E-01 (line 170) | ○ |
| C-24 | 目標処理時間30-60分 | **根拠なし** | △ |
| C-25 | GYP_DEFINESはKerberos問題回避用 | E-08 (コメント) | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（30-60分）は実測値やSLA定義文書からの根拠がなく、推定値
  - 候補：CI/CDパフォーマンス計測結果 / GitHub Actions実行履歴 / 運用ドキュメント
- GYP_DEFINESの目的はワークフロー内コメントに基づく推測であり、公式ドキュメントでの確認が望ましい
  - 候補：Node.js GYP設定ドキュメント / kerberos npmパッケージのREADME

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー構造と入出力パラメータは明確に文書化
- 1: 中リスク - タイムアウト値は変更される可能性あり（運用実績に基づく調整）
- 0: 低リスク - キャッシュ戦略はソースコードで明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ（job_name, electron_tests, browser_tests, remote_tests）の説明が正確か
- [ ] リトライ回数（npm ci: 5回、Electron: 3回）がソースと一致するか
- [ ] タイムアウト値が最新のワークフローと一致するか
- [ ] アーキテクチャ（arm64）の記述が正確か
