---
generated_at: 2026-01-27 10:32:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：12-pr-win32-test.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間30-60分**：推定値のため要確認
  2. **Windowsが最も利用者が多い**：マーケット統計からの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/pr-win32-test.yml`（行1-279）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行13）
- E-03: `.github/workflows/pr-win32-test.yml`（行20：runs-on self-hosted pool）
- E-04: `.github/workflows/pr-win32-test.yml`（行23-24：NPM_ARCH x64, VSCODE_ARCH x64）
- E-05: `.github/workflows/pr-win32-test.yml`（行59-72：npm ciリトライロジック）
- E-06: `.github/workflows/pr-win32-test.yml`（行120-133：Electronダウンロードリトライ）
- E-07: `.github/workflows/pr-win32-test.yml`（行49-50：7z展開）
- E-08: `.github/workflows/pr-win32-test.yml`（行184-186, 206-210, 212-216：diagnostics）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workflow_callで呼び出される再利用可能ワークフロー | E-01 (line 2) | ○ |
| C-02 | 1es-vscode-oss-windows-2022-x64プールで実行 | E-03 | ○ |
| C-03 | x64アーキテクチャで実行 | E-04 | ○ |
| C-04 | job_name入力パラメータが必須 | E-01 (line 4-6) | ○ |
| C-05 | electron_testsはデフォルトfalse | E-01 (line 7-9) | ○ |
| C-06 | browser_testsはデフォルトfalse | E-01 (line 10-12) | ○ |
| C-07 | remote_testsはデフォルトfalse | E-01 (line 13-15) | ○ |
| C-08 | npm ci最大5回リトライ | E-05 | ○ |
| C-09 | Electronダウンロード最大3回リトライ | E-06 | ○ |
| C-10 | 7-Zipでキャッシュ圧縮・展開 | E-07 | ○ |
| C-11 | Chromiumブラウザでテスト実行 | E-01 (line 152, 197) | ○ |
| C-12 | ユニットテスト15分タイムアウト | E-01 (line 141, 147) | ○ |
| C-13 | ブラウザテスト20分タイムアウト | E-01 (line 155) | ○ |
| C-14 | 統合テスト20分タイムアウト | E-01 (line 192, 198, 204) | ○ |
| C-15 | スモークテスト20分タイムアウト | E-01 (line 229, 235, 241) | ○ |
| C-16 | クラッシュレポートをartifactとしてアップロード | E-01 (line 251-258) | ○ |
| C-17 | ログファイルをartifactとしてアップロード | E-01 (line 271-278) | ○ |
| C-18 | node_modulesキャッシュを使用 | E-01 (line 40-45) | ○ |
| C-19 | built-in extensionsキャッシュを使用 | E-01 (line 99-105) | ○ |
| C-20 | PowerShellでスクリプト実行 | E-01 (shell: pwsh) | ○ |
| C-21 | npm_config_foreground_scripts=true設定 | E-01 (line 75) | ○ |
| C-22 | listprocesses.batで診断情報収集 | E-08 | ○ |
| C-23 | test.batでユニットテスト実行 | E-01 (line 140) | ○ |
| C-24 | test-integration.batで統合テスト実行 | E-01 (line 191) | ○ |
| C-25 | 目標処理時間30-60分 | **根拠なし** | △ |
| C-26 | Windowsが最も利用者が多い | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（30-60分）は実測値やSLA定義文書からの根拠がなく、推定値
  - 候補：CI/CDパフォーマンス計測結果 / GitHub Actions実行履歴 / 運用ドキュメント
- Windowsユーザーが最も多いという主張は、VSCode公式統計やマーケットシェアデータでの確認が望ましい
  - 候補：VSCode公式ブログ / Stack Overflow Developer Survey

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー構造と入出力パラメータは明確に文書化
- 1: 中リスク - self-hostedランナープールの可用性は運用環境依存
- 0: 低リスク - キャッシュ戦略（7z形式）はソースコードで明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ（job_name, electron_tests, browser_tests, remote_tests）の説明が正確か
- [ ] リトライ回数（npm ci: 5回、Electron: 3回）がソースと一致するか
- [ ] タイムアウト値が最新のワークフローと一致するか
- [ ] 7-Zip使用の記述が正確か
- [ ] PowerShellスクリプトの記述が正確か
