---
generated_at: 2026-01-27 10:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-pr-linux-cli-test.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5-15分**：推定値のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/pr-linux-cli-test.yml`（行1-47）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行14）
- E-03: `.github/workflows/pr-linux-cli-test.yml`（行14：runs-on self-hosted pool）
- E-04: `.github/workflows/pr-linux-cli-test.yml`（行16：RUSTUP_TOOLCHAIN環境変数）
- E-05: `.github/workflows/pr-linux-cli-test.yml`（行22-25：Rustインストール）
- E-06: `.github/workflows/pr-linux-cli-test.yml`（行32：clippy component追加）
- E-07: `.github/workflows/pr-linux-cli-test.yml`（行41：clippy -D warnings）
- E-08: `.github/workflows/pr-linux-cli-test.yml`（行45-46：cargo test）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workflow_callで呼び出される再利用可能ワークフロー | E-01 (line 2) | ○ |
| C-02 | 1es-vscode-oss-ubuntu-22.04-x64プールで実行 | E-03 | ○ |
| C-03 | job_name入力パラメータが必須 | E-01 (line 4-6) | ○ |
| C-04 | rustup_toolchain入力パラメータが必須 | E-01 (line 7-9) | ○ |
| C-05 | RUSTUP_TOOLCHAIN環境変数を設定 | E-04 | ○ |
| C-06 | rustup.shでRustをインストール | E-05 | ○ |
| C-07 | minimal profileでインストール | E-05 | ○ |
| C-08 | rustup default でツールチェーン設定 | E-01 (line 30) | ○ |
| C-09 | rustup updateでツールチェーン更新 | E-01 (line 31) | ○ |
| C-10 | Clippyコンポーネントを追加 | E-06 | ○ |
| C-11 | rustc --versionでバージョン確認 | E-01 (line 37) | ○ |
| C-12 | cargo --versionでバージョン確認 | E-01 (line 38) | ○ |
| C-13 | cargo clippy -- -D warnings を実行 | E-07 | ○ |
| C-14 | cliディレクトリで作業 | E-01 (line 42-43, 46) | ○ |
| C-15 | cargo testを実行 | E-08 | ○ |
| C-16 | 警告をエラーとして扱う | E-07 (-D warnings) | ○ |
| C-17 | CLIはRust製 | E-02 | ○ |
| C-18 | 目標処理時間5-15分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（5-15分）は実測値やSLA定義文書からの根拠がなく、推定値
  - 候補：CI/CDパフォーマンス計測結果 / GitHub Actions実行履歴 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー構造が単純で明確
- 0: 低リスク - Rustツールチェーン設定が標準的
- 0: 低リスク - Clippy/cargo testは標準的なRust品質検証手法

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ（job_name, rustup_toolchain）の説明が正確か
- [ ] Rust関連コマンドの順序が正確か
- [ ] -D warningsオプションの説明が正確か
- [ ] 作業ディレクトリ（cli）の記述が正確か
