---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：16-copilot-setup-steps.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間10-20分**：推定値のため要確認
  2. **Copilotが独自トークンで操作**：GitHub Copilot仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/copilot-setup-steps.yml`（行1-261）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行17）
- E-03: `.github/workflows/copilot-setup-steps.yml`（行5-12：トリガー定義）
- E-04: `.github/workflows/copilot-setup-steps.yml`（行15：ジョブ名copilot-setup-steps）
- E-05: `.github/workflows/copilot-setup-steps.yml`（行17：vscode-large-runners）
- E-06: `.github/workflows/copilot-setup-steps.yml`（行20-23：permissions）
- E-07: `.github/workflows/copilot-setup-steps.yml`（行36-51：system services setup）
- E-08: `.github/workflows/copilot-setup-steps.yml`（行73-80, 86-98：npm ci リトライ）
- E-09: `.github/workflows/copilot-setup-steps.yml`（行141-154：Electron/Playwright ダウンロード）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workflow_dispatch/push/pull_requestで実行 | E-03 | ○ |
| C-02 | copilot-setup-steps.ymlのpaths制限あり | E-03 (line 8-9, 11-12) | ○ |
| C-03 | vscode-large-runnersで実行 | E-05 | ○ |
| C-04 | ジョブ名はcopilot-setup-steps | E-04 | ○ |
| C-05 | permissions: contents: read | E-06 | ○ |
| C-06 | xvfbをインストール | E-07 (line 42) | ○ |
| C-07 | apt-retry.shでリトライ | E-07 (line 40-41) | ○ |
| C-08 | libgtk-3-0をインストール | E-07 (line 43) | ○ |
| C-09 | npm ci最大5回リトライ | E-08 | ○ |
| C-10 | Electronダウンロード最大3回リトライ | E-09 | ○ |
| C-11 | リトライ間隔5秒 | E-09 (line 153) | ○ |
| C-12 | node_modulesキャッシュを使用 | E-01 (line 56-65) | ○ |
| C-13 | built-in extensionsキャッシュを使用 | E-01 (line 120-126) | ○ |
| C-14 | electron x64をダウンロード | E-09 (line 142) | ○ |
| C-15 | playwright-installを実行 | E-09 (line 142) | ○ |
| C-16 | x64アーキテクチャ | E-01 (line 54, 100-101) | ○ |
| C-17 | ELECTRON_SKIP_BINARY_DOWNLOAD=1 | E-01 (line 102) | ○ |
| C-18 | PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1 | E-01 (line 103) | ○ |
| C-19 | transpileステップはコメントアウト | E-01 (line 134-135) | ○ |
| C-20 | テスト実行ステップはコメントアウト | E-01 (line 158-260) | ○ |
| C-21 | xvfb.initをコピーして設定 | E-07 (line 48-51) | ○ |
| C-22 | buildディレクトリの依存関係を先にインストール | E-08 (line 67-80) | ○ |
| C-23 | 目標処理時間10-20分 | **根拠なし** | △ |
| C-24 | Copilotが独自トークンで操作 | E-06 (comment) | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（10-20分）は実測値やSLA定義文書からの根拠がなく、推定値
  - 候補：CI/CDパフォーマンス計測結果 / GitHub Actions実行履歴 / 運用ドキュメント
- Copilotが独自トークンで操作するという記述はコメントに基づくが、GitHub Copilot公式ドキュメントでの確認が望ましい
  - 候補：GitHub Copilot Workspaces ドキュメント / GitHub Actions ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー構造が他のテストワークフローと類似
- 1: 中リスク - xvfb設定はLinux固有で、他環境での再現性に注意
- 0: 低リスク - キャッシュ戦略はソースコードで明確に定義
- 1: 中リスク - コメントアウトされたステップの存在（将来的に有効化される可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] ジョブ名がcopilot-setup-stepsであることを確認
- [ ] トリガー条件（workflow_dispatch/push/pull_request）が正確か
- [ ] paths制限（copilot-setup-steps.yml）が正確か
- [ ] インストールされるLinuxパッケージ一覧が正確か
- [ ] リトライ回数（npm ci: 5回、Electron: 3回）がソースと一致するか
- [ ] コメントアウトされたステップの説明が正確か
