---
generated_at: 2026-01-27 10:44:00
metrics:
  claims_total: 21
  claims_with_evidence: 19
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：18-watch.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：19 / 21、根拠なし：2
- 優先レビュー（高）
  1. **変更検知から再コンパイル完了まで1-3秒**：推定値のため要確認
  2. **npm run watch コマンド**：package.jsonでの定義確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/gulpfile.ts`（行1-59）
- E-02: `build/lib/compilation.ts`（行1-359）
- E-03: `build/gulpfile.extensions.ts`（行1-274）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行19）
- E-05: `build/gulpfile.ts`（行44：watchタスク定義）
- E-06: `build/gulpfile.ts`（行37：watch-client定義）
- E-07: `build/lib/compilation.ts`（行166-184：watchTask関数）
- E-08: `build/lib/compilation.ts`（行172：readDelay: 200）
- E-09: `build/lib/compilation.ts`（行350-358：watchApiProposalNamesTask）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | watchタスクはtask.parallel | E-05 | ○ |
| C-02 | watchClientTask, watchExtensionsTaskを並列実行 | E-05 | ○ |
| C-03 | watch-clientはtask.series | E-06 | ○ |
| C-04 | rimraf('out')でクリーンアップ | E-06 | ○ |
| C-05 | watchTask('out', false)を実行 | E-06 | ○ |
| C-06 | watchApiProposalNamesTaskを並列実行 | E-06 | ○ |
| C-07 | watchTask関数でファイル監視 | E-07 | ○ |
| C-08 | readDelay: 200msでデバウンス | E-08 | ○ |
| C-09 | util.incremental()でインクリメンタルコンパイル | E-07 (line 179) | ○ |
| C-10 | emitError: falseでエラー時も継続 | E-07 (line 169) | ○ |
| C-11 | MonacoGeneratorはウォッチモードで動作 | E-07 (line 174-175) | ○ |
| C-12 | watch-extensions並列実行 | E-03 (line 188-189) | ○ |
| C-13 | watch-api-proposal-namesはvscode-dts監視 | E-09 | ○ |
| C-14 | extensionsApiProposals.tsを再生成 | E-09 | ○ |
| C-15 | watch/index.tsで監視実装 | E-07 (line 22) | ○ |
| C-16 | src/**を監視 | E-07 (line 172) | ○ |
| C-17 | MonacoGenerator.execute()を呼び出し | E-07 (line 175) | ○ |
| C-18 | gulp.dest(out)で出力 | E-07 (line 180) | ○ |
| C-19 | debounceでAPI提案名タスクを制御 | E-09 (line 356) | ○ |
| C-20 | 変更検知から再コンパイル完了まで1-3秒 | **根拠なし** | △ |
| C-21 | npm run watch コマンドで実行可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 再コンパイル時間（1-3秒）は実測値やパフォーマンス要件文書からの根拠がなく、推定値
  - 候補：開発者体験測定結果 / パフォーマンスベンチマーク
- npm run watchコマンドの存在はpackage.jsonでの確認が必要
  - 候補：package.json scripts セクション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Gulpタスク構造はソースコードで明確に定義
- 0: 低リスク - 並列/直列実行の関係が明確
- 1: 中リスク - Linuxでのinotify上限に関する注意事項は環境依存
- 0: 低リスク - emitError: falseによりエラー耐性が確保されている

## 6) レビュアーチェックリスト（最小）
- [ ] watchタスクの並列実行対象が正確か
- [ ] watch-clientの直列実行順序が正確か
- [ ] readDelay値（200ms）が正確か
- [ ] emitError: falseの説明が正確か
- [ ] インクリメンタルコンパイルの説明が正確か
- [ ] MonacoGeneratorのウォッチモード動作の説明が正確か
