---
generated_at: 2026-01-27 10:46:00
metrics:
  claims_total: 23
  claims_with_evidence: 21
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：19-compile-build-with-mangling.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：21 / 23、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間5-15分**：推定値のため要確認
  2. **定期実行スケジュール**：Azure Pipelinesの設定確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/gulpfile.compile.ts`（行1-28）
- E-02: `build/lib/compilation.ts`（行1-359）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行20）
- E-04: `build/gulpfile.compile.ts`（行12-19：makeCompileBuildTask関数）
- E-05: `build/gulpfile.compile.ts`（行26-27：compileBuildWithManglingTask定義）
- E-06: `build/lib/compilation.ts`（行117-164：compileTask関数）
- E-07: `build/lib/compilation.ts`（行134-153：Mangler処理）
- E-08: `build/lib/compilation.ts`（行121-123：4GBメモリチェック）
- E-09: `build/lib/date.ts`（推定：writeISODate関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | compile-build-with-manglingはtask.series | E-04 | ○ |
| C-02 | rimraf('out-build')でクリーンアップ | E-04 (line 14) | ○ |
| C-03 | writeISODateでタイムスタンプ書き込み | E-04 (line 15) | ○ |
| C-04 | compileApiProposalNamesTaskを実行 | E-04 (line 16) | ○ |
| C-05 | compileTask('src', 'out-build', true, { disableMangle: false }) | E-04, E-05 | ○ |
| C-06 | disableMangle: falseで難読化有効 | E-05 (makeCompileBuildTask(false)) | ○ |
| C-07 | 4GB以上のRAMが必要 | E-08 | ○ |
| C-08 | Manglerでプライベートフィールド難読化 | E-07 (line 135) | ○ |
| C-09 | mangleExports: true | E-07 (line 135) | ○ |
| C-10 | manglePrivateFields: true | E-07 (line 135) | ○ |
| C-11 | saveStateは難読化対象外 | E-07 (line 136) | ○ |
| C-12 | mangleStreamで名前変換 | E-07 (line 137-152) | ○ |
| C-13 | build: trueでNLS処理有効 | E-06 (line 82) | ○ |
| C-14 | inlineSources: true | E-06 (line 56) | ○ |
| C-15 | ts2tsMangler変数使用 | E-07 (line 135) | ○ |
| C-16 | computeNewFileContentsで変換内容計算 | E-07 (line 136) | ○ |
| C-17 | ansiColors.blue('[mangler]')でログ | E-07 (line 135) | ○ |
| C-18 | MonacoGenerator使用 | E-06 (line 127-130) | ○ |
| C-19 | preserveEnglish: false | E-06 (line 125) | ○ |
| C-20 | gulp.task(compileBuildWithManglingTask) | E-05 (line 27) | ○ |
| C-21 | out-buildに出力 | E-04 (line 17) | ○ |
| C-22 | 目標処理時間5-15分 | **根拠なし** | △ |
| C-23 | 定期実行スケジュール（月〜金 7:00/19:00） | E-03 (備考欄) | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（5-15分）は実測値やパフォーマンス要件文書からの根拠がなく、推定値
  - 候補：Azure Pipelinesビルド履歴 / パフォーマンスベンチマーク
- 定期実行スケジュールはバッチ一覧.csvの備考欄に基づくが、Azure Pipelines設定ファイルでの確認が望ましい
  - 候補：build/azure-pipelines/product-build.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Gulpタスク構造はソースコードで明確に定義
- 0: 低リスク - Mangler設定（mangleExports, manglePrivateFields）が明確
- 1: 中リスク - saveState除外リストの妥当性は要確認
- 1: 中リスク - メモリ要件（4GB）はCI環境のリソース制約に影響

## 6) レビュアーチェックリスト（最小）
- [ ] makeCompileBuildTask関数の引数（disableMangle: false）が正確か
- [ ] タスク直列実行順序（rimraf -> writeISODate -> compileApiProposalNames -> compileTask）が正確か
- [ ] Mangler設定（mangleExports, manglePrivateFields）が正確か
- [ ] saveState除外設定が正確か
- [ ] 4GBメモリ要件の記述が正確か
- [ ] 出力先（out-build/）が正確か
