---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-product-compile

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/product-compile.yml` (L1-172)
- E-02: `build/azure-pipelines/product-build.yml` (L197-202)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L3)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ名はCompile | E-01 L2 (job: Compile) | ○ |
| C-02 | タイムアウトは60分 | E-01 L3 (timeoutInMinutes: 60) | ○ |
| C-03 | 成果物名はCompilation | E-01 L8 (artifactName: Compilation) | ○ |
| C-04 | 出力ファイルはcompilation.tar.gz | E-01 L7 (targetPath: .../compilation.tar.gz) | ○ |
| C-05 | common/checkout.ymlでチェックアウト | E-01 L13 (template: ./common/checkout.yml) | ○ |
| C-06 | .nvmrcからNode.jsバージョン取得 | E-01 L15-18 (NodeTool@0, versionFilePath: .nvmrc) | ○ |
| C-07 | distro/download-distro.ymlでdistro取得 | E-01 L20 (template: ./distro/download-distro.yml) | ○ |
| C-08 | Key Vaultからgithub-distro-mixin-password取得 | E-01 L22-28 (AzureKeyVault@2) | ○ |
| C-09 | setup-npm-registry.tsでNPMレジストリ設定 | E-01 L29-31 (node build/setup-npm-registry.ts) | ○ |
| C-10 | computeNodeModulesCacheKey.tsでキャッシュキー計算 | E-01 L33 (computeNodeModulesCacheKey.ts) | ○ |
| C-11 | Cache@2タスクでキャッシュ復元 | E-01 L36-41 (Cache@2) | ○ |
| C-12 | npm ciを5回リトライ | E-01 L63-79 (for i in {1..5}) | ○ |
| C-13 | ELECTRON_SKIP_BINARY_DOWNLOAD=1設定 | E-01 L75 (env設定) | ○ |
| C-14 | mixin-npm.tsでdistro node_modulesミックスイン | E-01 L81-83 (mixin-npm.ts) | ○ |
| C-15 | npm-run-all2で並列コンパイル実行 | E-01 L98 (npm exec -- npm-run-all2 -lp) | ○ |
| C-16 | core-ci, extensions-ci, hygiene, eslint等を実行 | E-01 L98 (コマンド引数) | ○ |
| C-17 | out-buildフォルダの存在検証 | E-01 L106 ([ -d "out-build" ]) | ○ |
| C-18 | out-vscode-*フォルダの存在検証 | E-01 L110-115 (for folder in out-vscode-*) | ○ |
| C-19 | test/smokeでnpm run compile実行 | E-01 L120-125 (workingDirectory: test/smoke) | ○ |
| C-20 | upload-sourcemaps.tsでソースマップアップロード | E-01 L146-152 (upload-sourcemaps.ts) | ○ |
| C-21 | extract-telemetry.shでテレメトリ抽出 | E-01 L155 (extract-telemetry.sh) | ○ |
| C-22 | ComponentGovernanceで依存関係検出 | E-01 L166-171 (ComponentGovernanceComponentDetection@0) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がproduct-compile.ymlから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] npm-run-all2の並列実行タスク一覧が最新かどうか確認
- [ ] コンパイル成果物に含まれるディレクトリ一覧が正確か確認（L158のtarコマンド）
- [ ] VSCODE_STEP_ON_IT条件でスキップされる処理範囲が適切か確認
