---
generated_at: 2026-01-27 10:48:00
metrics:
  claims_total: 21
  claims_with_evidence: 19
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：20-compile-build-without-mangling.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：19 / 21、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間3-10分**：推定値のため要確認
  2. **難読化なしのため高速**：比較データが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/gulpfile.compile.ts`（行1-28）
- E-02: `build/lib/compilation.ts`（行1-359）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行21）
- E-04: `build/gulpfile.compile.ts`（行12-19：makeCompileBuildTask関数）
- E-05: `build/gulpfile.compile.ts`（行22-23：compileBuildWithoutManglingTask定義）
- E-06: `build/lib/compilation.ts`（行117-164：compileTask関数）
- E-07: `build/lib/compilation.ts`（行133-134：disableMangle条件）
- E-08: `build/lib/compilation.ts`（行121-123：4GBメモリチェック）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | compile-build-without-manglingはtask.series | E-04 | ○ |
| C-02 | rimraf('out-build')でクリーンアップ | E-04 (line 14) | ○ |
| C-03 | writeISODateでタイムスタンプ書き込み | E-04 (line 15) | ○ |
| C-04 | compileApiProposalNamesTaskを実行 | E-04 (line 16) | ○ |
| C-05 | compileTask('src', 'out-build', true, { disableMangle: true }) | E-04, E-05 | ○ |
| C-06 | disableMangle: trueで難読化無効 | E-05 (makeCompileBuildTask(true)) | ○ |
| C-07 | 4GB以上のRAMが必要 | E-08 | ○ |
| C-08 | mangleStream = es.through()でスルー | E-07 (line 133) | ○ |
| C-09 | 難読化処理をスキップ | E-07 | ○ |
| C-10 | build: trueでNLS処理有効 | E-06 (line 82) | ○ |
| C-11 | inlineSources: true | E-06 (line 56) | ○ |
| C-12 | MonacoGenerator使用 | E-06 (line 127-130) | ○ |
| C-13 | preserveEnglish: false | E-06 (line 125) | ○ |
| C-14 | gulp.task(compileBuildWithoutManglingTask) | E-05 (line 23) | ○ |
| C-15 | out-buildに出力 | E-04 (line 17) | ○ |
| C-16 | compile-build-with-manglingとの違いはdisableMangleのみ | E-04, E-05 | ○ |
| C-17 | ローカル/PRビルド用 | E-01 (line 21 comment) | ○ |
| C-18 | out-buildディレクトリは共有 | E-04 | ○ |
| C-19 | buildフラグがtrue | E-04 (line 17) | ○ |
| C-20 | 目標処理時間3-10分 | **根拠なし** | △ |
| C-21 | 難読化なしのため高速 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間（3-10分）は実測値やパフォーマンス要件文書からの根拠がなく、推定値
  - 候補：ビルドパフォーマンス計測結果 / CI実行履歴
- 難読化なしで高速という主張は、compile-build-with-manglingとの比較データが必要
  - 候補：ビルド時間比較ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Gulpタスク構造はソースコードで明確に定義
- 0: 低リスク - compile-build-with-manglingと対称的な設定
- 0: 低リスク - disableMangle: trueの効果が明確
- 1: 中リスク - out-buildディレクトリ共有による潜在的な競合

## 6) レビュアーチェックリスト（最小）
- [ ] makeCompileBuildTask関数の引数（disableMangle: true）が正確か
- [ ] タスク直列実行順序（rimraf -> writeISODate -> compileApiProposalNames -> compileTask）が正確か
- [ ] mangleStream = es.through()の説明が正確か
- [ ] 4GBメモリ要件の記述が正確か
- [ ] 出力先（out-build/）が正確か
- [ ] compile-build-with-manglingとの違いの説明が正確か
