---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-hygiene

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：明確な数値根拠なし
  2. **CI/CDパイプラインでの実行タイミング**：詳細フロー未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/hygiene.ts` - hygieneメイン処理実装
- E-02: `build/gulpfile.hygiene.ts` - Gulpタスク定義
- E-03: `package.json` - npm scripts定義（precommit, hygiene）
- E-04: `build/filters.ts` - ファイルフィルター定義（参照のみ）
- E-05: `build/gulp-eslint.ts` - ESLint実行処理（参照のみ）
- E-06: `build/stylelint.ts` - Stylelint実行処理（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Gulpタスクとして実装されている | E-02 | ○ |
| C-02 | package.json整合性チェックを実行 | E-02 (checkPackageJSON関数) | ○ |
| C-03 | コピーライトヘッダー検証を実行 | E-01 (copyrights処理) | ○ |
| C-04 | Unicode文字制限チェックを実行 | E-01 (unicode処理) | ○ |
| C-05 | インデント検証を実行 | E-01 (indentation処理) | ○ |
| C-06 | TypeScriptフォーマット検証を実行 | E-01 (formatting処理) | ○ |
| C-07 | ESLint実行をオプションで制御可能 | E-01 (runEslintパラメータ) | ○ |
| C-08 | Stylelint実行を含む | E-01 (gulpstylelint呼び出し) | ○ |
| C-09 | precommitフックとして使用可能 | E-03 (precommitスクリプト) | ○ |
| C-10 | Gitステージングファイルを対象にできる | E-01 (createGitIndexVinyls関数) | ○ |
| C-11 | BUILD_SOURCEVERSION時はproduct.json検証をスキップ | E-01 (process.env条件) | ○ |
| C-12 | エラー件数をカウントして終了コードを決定 | E-01 (errorCount変数) | ○ |
| C-13 | メモリ上限8192MBで設定 | E-03 (gulp呼び出しオプション) | ○ |
| C-14 | 許可Unicode文字の正規表現パターン | E-01 (unicode処理内の正規表現) | ○ |
| C-15 | remote/package.json等との整合性チェック | E-02 (checkPackageJSON呼び出し) | ○ |
| C-16 | allow-any-unicode-next-lineコメントで抑制可能 | E-01 (skipNext処理) | ○ |
| C-17 | 目標処理時間は数分以内 | **根拠なし** | △ |
| C-18 | CI/CDパイプラインでcore-ciの一部として実行 | **根拠なし（別ファイル要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間について明確な性能要件の根拠がない
  - 候補：CI/CDパイプライン実行ログ / 性能テスト結果 / 開発ガイドライン
- CI/CDでの正確な実行位置（core-ciタスク内）の詳細フロー
  - 候補：Azure Pipelines YAML / GitHub Actions YAML

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - パフォーマンス要件は実測値確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] hygiene.tsの主要処理がすべて設計書に反映されているか
- [ ] フィルターパターン（filters.ts）の詳細が必要か検討
- [ ] CI/CD実行フローとの整合性を確認
- [ ] エラーメッセージの網羅性を確認
