---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：26-postinstall

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **対象ディレクトリ数「約60」**：具体的なカウント根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/npm/postinstall.ts` - postinstallメイン実装
- E-02: `build/npm/dirs.ts` - 対象ディレクトリリスト
- E-03: `package.json` - postinstallスクリプト定義
- E-04: `build/npm/postinstall.ts` - removeParcelWatcherPrebuild関数
- E-05: `build/npm/postinstall.ts` - setNpmrcConfig関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmスクリプトとして実装 | E-03 (postinstallスクリプト定義) | ○ |
| C-02 | build/npm/postinstall.tsで実装 | E-01 (ファイル実在) | ○ |
| C-03 | build/npm/dirs.tsからディレクトリリスト取得 | E-01 (import dirs), E-02 | ○ |
| C-04 | npm_command環境変数でinstall/ci判定 | E-01 (process.env['npm_command']) | ○ |
| C-05 | ルートディレクトリはparcelモジュール削除のみ | E-01 (dir === ''条件) | ○ |
| C-06 | buildディレクトリで環境変数設定 | E-01 (dir === 'build'条件) | ○ |
| C-07 | .npmrc設定をsetNpmrcConfigで適用 | E-05 (関数実装) | ○ |
| C-08 | remoteディレクトリでDocker対応 | E-01 (VSCODE_REMOTE_DEPENDENCIES_CONTAINER_NAME条件) | ○ |
| C-09 | @parcel/watcherプレビルドモジュールを削除 | E-04 (removeParcelWatcherPrebuild関数) | ○ |
| C-10 | Git設定を更新（pull.rebase） | E-01 (git config pull.rebase merges) | ○ |
| C-11 | Git設定を更新（blame.ignoreRevsFile） | E-01 (git config blame.ignoreRevsFile) | ○ |
| C-12 | macOSでforce_process_config設定 | E-05 (process.platform === 'darwin'条件) | ○ |
| C-13 | node-gypパスを設定 | E-05 (npm_config_node_gyp設定) | ○ |
| C-14 | arm64アーキテクチャでqemu設定 | E-01 (npm_config_arch === 'arm64'条件) | ○ |
| C-15 | エラー時にexit(1) | E-01 (process.exit(result.status)) | ○ |
| C-16 | TTY判定でカラー出力 | E-01 (process.stdout.isTTY条件) | ○ |
| C-17 | .build/distro/npm/存在時に追加ディレクトリ | E-02 (existsSync条件) | ○ |
| C-18 | 対象ディレクトリ数は約60 | **根拠不足（要カウント）** | △ |

## 4) 不足情報（Unknown / Missing）
- 対象ディレクトリの正確な数のカウント
  - 候補：dirs.tsの配列要素数を数える

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - Docker関連処理の詳細は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] dirs.tsのディレクトリ数を正確にカウント
- [ ] Docker環境での動作確認（必要に応じて）
- [ ] リモートビルド環境変数の設定確認
