---
generated_at: 2026-01-27 10:42:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-preinstall

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/npm/preinstall.ts` - preinstallメイン実装
- E-02: `package.json` - preinstallスクリプト定義
- E-03: `build/npm/preinstall.ts` - hasSupportedVisualStudioVersion関数
- E-04: `build/npm/preinstall.ts` - installHeaders関数
- E-05: `build/npm/preinstall.ts` - getHeaderInfo関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmスクリプトとして実装 | E-02 (preinstallスクリプト定義) | ○ |
| C-02 | build/npm/preinstall.tsで実装 | E-01 (ファイル実在) | ○ |
| C-03 | VSCODE_SKIP_NODE_VERSION_CHECKでスキップ可能 | E-01 (process.env条件) | ○ |
| C-04 | .nvmrcからバージョン読み込み | E-01 (nvmrcPath, readFileSync) | ○ |
| C-05 | バージョン比較（メジャー.マイナー.パッチ） | E-01 (比較ロジック) | ○ |
| C-06 | yarn使用時にエラー | E-01 (npm_execpath.includes('yarn')) | ○ |
| C-07 | Windows環境でVSチェック | E-01, E-03 (platform === 'win32') | ○ |
| C-08 | VS 2022/2019をサポート | E-03 (supportedVersions配列) | ○ |
| C-09 | 環境変数でVSパス指定可能 | E-03 (vs2022_install等) | ○ |
| C-10 | 複数のVS Editionを検索 | E-03 (vsTypes配列) | ○ |
| C-11 | node-gyp installを実行 | E-04 (execFileSync) | ○ |
| C-12 | .npmrcからdisturl/target取得 | E-05 (getHeaderInfo関数) | ○ |
| C-13 | ローカル/リモート両方のヘッダーインストール | E-04 (local, remote呼び出し) | ○ |
| C-14 | Linuxでパッチ適用 | E-04 (platform === 'linux'条件) | ○ |
| C-15 | アーキテクチャミスマッチ警告 | E-01 (process.arch !== os.arch()) | ○ |
| C-16 | ANSIエスケープコードで赤色表示 | E-01 (\\x1b[1;31m使用) | ○ |
| C-17 | throw new Error()でプロセス終了 | E-01 (throw文) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Visual Studioの検索パスが最新か確認
- [ ] v8-source-location.patchの内容を確認（必要に応じて）
- [ ] node-gypのバージョン互換性を確認
