---
generated_at: 2026-01-27 10:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：29-download-builtin-extensions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **拡張機能数「数十」**：具体的なカウント根拠なし（product.json依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/lib/builtInExtensions.ts` - メイン実装
- E-02: `package.json` - download-builtin-extensionsスクリプト定義
- E-03: `build/lib/builtInExtensions.ts` - getBuiltInExtensions関数
- E-04: `build/lib/builtInExtensions.ts` - syncExtension関数
- E-05: `build/lib/builtInExtensions.ts` - isUpToDate関数
- E-06: `build/lib/extensions.ts` - fromMarketplace/fromGithub関数（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmスクリプトとして実装 | E-02 (download-builtin-extensionsスクリプト定義) | ○ |
| C-02 | build/lib/builtInExtensions.tsで実装 | E-01 (ファイル実在) | ○ |
| C-03 | product.jsonからbuiltInExtensions読み込み | E-01 (productjson.builtInExtensions) | ○ |
| C-04 | webBuiltInExtensionsも読み込み | E-01 (productjson.webBuiltInExtensions) | ○ |
| C-05 | control.jsonから状態読み込み | E-01 (readControlFile関数) | ○ |
| C-06 | control.jsonの場所は~/.vscode-oss-dev/extensions/ | E-01 (controlFilePath定義) | ○ |
| C-07 | .build/builtInExtensionsに配置 | E-01 (getExtensionPath関数) | ○ |
| C-08 | disabled状態でスキップ | E-04 (case 'disabled') | ○ |
| C-09 | marketplace状態でダウンロード | E-04 (case 'marketplace') | ○ |
| C-10 | バージョンチェック（isUpToDate） | E-05 (diskVersion === extension.version) | ○ |
| C-11 | プラットフォーム互換性チェック | E-04 (extension.platforms条件) | ○ |
| C-12 | vsixファイル優先 | E-01 (extension.vsix条件) | ○ |
| C-13 | Marketplace設定時はMarketplace使用 | E-01 (extensionsGallery?.serviceUrl条件) | ○ |
| C-14 | フォールバックでGitHub使用 | E-01 (fromGithub呼び出し) | ○ |
| C-15 | rimraf.syncで既存削除 | E-01 (rimraf.sync呼び出し) | ○ |
| C-16 | control.jsonを更新保存 | E-01 (writeControlFile関数) | ○ |
| C-17 | ENABLE_LOGGING環境変数でログ制御 | E-01 (VSCODE_BUILD_BUILTIN_EXTENSIONS_SILENCE_PLEASE) | ○ |
| C-18 | 拡張機能数は数十 | **根拠不足（product.json依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- builtInExtensionsの正確な数（product.jsonの内容に依存）
  - 候補：product.jsonの実データを確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - ネットワーク関連処理は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] product.jsonのbuiltInExtensions数を確認
- [ ] control.jsonの実際の構造を確認
- [ ] extensions.tsのfromMarketplace/fromGithub実装を確認（必要に応じて）
