---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-product-publish

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/product-publish.yml` (L1-117)
- E-02: `build/azure-pipelines/product-build.yml` (L483-491, L124)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L4)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ名はPublishBuild | E-01 L8 (job: PublishBuild) | ○ |
| C-02 | タイムアウトは180分 | E-01 L10 (timeoutInMinutes: 180) | ○ |
| C-03 | Windowsエージェントで実行 | E-01 L12-13 (pool: 1es-windows-2022-x64) | ○ |
| C-04 | BUILDS_API_URL変数を設定 | E-01 L14-15 (variables) | ○ |
| C-05 | artifacts_processed_*.txtを出力 | E-01 L17-25 (templateContext outputs) | ○ |
| C-06 | common/checkout.ymlでチェックアウト | E-01 L27 (template) | ○ |
| C-07 | Key Vaultからgithub-distro-mixin-password取得 | E-01 L34-39 (AzureKeyVault@2) | ○ |
| C-08 | vscode-esrpからesrp-auth, esrp-sign取得 | E-01 L41-46 (AzureKeyVault@2) | ○ |
| C-09 | ビルドタグとして絵文字追加 | E-01 L48-50 (addbuildtag) | ○ |
| C-10 | build/でnpm ci実行 | E-01 L52-57 (npm ci) | ○ |
| C-11 | 以前の処理済み成果物情報をダウンロード | E-01 L59-61 (download current) | ○ |
| C-12 | AzureCLI@2でIDトークン取得 | E-01 L63-74 (AzureCLI@2) | ○ |
| C-13 | createBuild.tsでビルド作成（初回のみ） | E-01 L76-90 (createBuild.ts) | ○ |
| C-14 | getPublishAuthTokens.tsで認証トークン取得 | E-01 L92-99 (getPublishAuthTokens.ts) | ○ |
| C-15 | publish.tsで成果物処理 | E-01 L101-109 (publish.ts) | ○ |
| C-16 | 成果物処理は3回リトライ | E-01 L110 (retryCountOnTaskFailure: 3) | ○ |
| C-17 | insider/exploration+スケジュールビルドでリリース | E-01 L112-116 (条件分岐) | ○ |
| C-18 | releaseBuild.tsでリリース実行 | E-01 L113 (releaseBuild.ts) | ○ |
| C-19 | VSCODE_PUBLISH条件で実行 | E-02 L124 (VSCODE_PUBLISH変数定義) | ○ |
| C-20 | PublishステージはdependsOn: []で独立実行 | E-02 L485 (dependsOn: []) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がproduct-publish.ymlから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ESRP認証情報（esrp-auth, esrp-sign）の有効期限を定期確認
- [ ] publish.tsの処理内容が最新の成果物フォーマットに対応しているか確認
- [ ] 自動リリースの条件（insider/exploration + スケジュールビルド）が運用要件と一致するか確認
