---
generated_at: 2026-01-27 10:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：30-smoketest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **テストケース数「約100」**：具体的なカウント根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/smoke/src/main.ts` - メインエントリポイント
- E-02: `package.json` - smoketestスクリプト定義
- E-03: `test/smoke/package.json` - スモークテストパッケージ設定
- E-04: `test/smoke/src/main.ts` - テストスイートのセットアップ
- E-05: `test/smoke/src/main.ts` - コマンドライン引数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmスクリプトとして実装 | E-02 (smoketestスクリプト定義) | ○ |
| C-02 | preLaunch.tsを実行 | E-02 (smoketestスクリプト内容) | ○ |
| C-03 | test/smoke/compileを実行 | E-02, E-03 (compileスクリプト) | ○ |
| C-04 | --build引数でビルドパス指定 | E-05 (minimist定義) | ○ |
| C-05 | --web引数でWeb版テスト | E-05 (minimist定義) | ○ |
| C-06 | --remote引数でリモートテスト | E-05 (minimist定義) | ○ |
| C-07 | --headless引数でヘッドレス実行 | E-05 (minimist定義) | ○ |
| C-08 | --verbose引数で詳細ログ | E-05 (minimist定義) | ○ |
| C-09 | テストリポジトリをクローン | E-01 (setupRepository関数) | ○ |
| C-10 | testRepoUrl = vscode-smoketest-express | E-01 (testRepoUrl定数) | ○ |
| C-11 | 安定版VSCodeをダウンロード | E-01 (ensureStableCode関数) | ○ |
| C-12 | retryで最大20回リトライ | E-01 (retry呼び出し, 1000, 20) | ○ |
| C-13 | ログを.build/logsに出力 | E-01 (logsRootPath定義) | ○ |
| C-14 | クラッシュを.build/crashesに出力 | E-01 (crashesRootPath定義) | ○ |
| C-15 | 各テストカテゴリをsetup | E-04 (setup関数群のimport/呼び出し) | ○ |
| C-16 | Web版ではノートブックテストをスキップ | E-04 (!opts.web条件) | ○ |
| C-17 | Dev/OSSでは拡張機能テストをスキップ | E-04 (quality条件) | ○ |
| C-18 | VSCODE_DEV=1で開発モード判定 | E-01 (parseQuality関数) | ○ |
| C-19 | graceful-fsを使用 | E-01 (gracefulify呼び出し) | ○ |
| C-20 | テストケース数は約100 | **根拠不足（要カウント）** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なテストケース数のカウント
  - 候補：各テストファイルのdescribe/it数を集計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - テスト実行環境依存の挙動あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストカテゴリのテストケース数を確認
- [ ] CI/CD環境での実行設定を確認
- [ ] タイムアウト設定の妥当性を確認
