---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-test-browser バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間5分**：具体的な数値の根拠が不明
  2. **メモリ使用量上限1GB**：ブラウザの実際の使用量は未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - npmスクリプト定義
- E-02: `test/unit/browser/index.js` - ブラウザテストエントリーポイント
- E-03: `バッチ一覧.csv` - バッチ概要説明
- E-04: `.github/workflows/pr.yml`（推定）- CI実行トリガー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | test-browserはPlaywrightを使用してテストを実行 | E-01, E-02 | ○ |
| C-02 | Chromium、Firefox、WebKitの3ブラウザに対応 | E-02 (args.browser default) | ○ |
| C-03 | npmスクリプトとして定義されている | E-01 (`"test-browser": "npx playwright install && node test/unit/browser/index.js"`) | ○ |
| C-04 | Mochaをテストランナーとして使用 | E-02 (mocha import, MochaJUnitReporter) | ○ |
| C-05 | --buildオプションでout-buildを使用可能 | E-02 (args.build処理) | ○ |
| C-06 | --grepオプションでテストフィルタリング | E-02 (args.grep処理) | ○ |
| C-07 | HTTPサーバーはyaserverを使用 | E-02 (yaserver import, createServer関数) | ○ |
| C-08 | ランダムプレフィックスでセキュリティ確保 | E-02 (randomBytes(16).toString('hex')) | ○ |
| C-09 | node/electron系テストは除外される | E-02 (excludeGlob定義) | ○ |
| C-10 | CI環境でJUnit形式レポート出力 | E-02 (MochaJUnitReporter, args.tfs処理) | ○ |
| C-11 | 失敗時は終了コード1を返す | E-02 (process.exit(didFail ? 1 : 0)) | ○ |
| C-12 | --debugオプションでヘッドレス無効化 | E-02 (headless: !Boolean(args.debug)) | ○ |
| C-13 | --sequentialオプションで順次実行 | E-02 (args.sequential処理) | ○ |
| C-14 | 複数ブラウザの並列実行をサポート | E-02 (Promise.all(browsers.map(...))) | ○ |
| C-15 | CSSモジュールを圧縮して送信 | E-02 (CompressionStream, _devCssData) | ○ |
| C-16 | NLSメッセージをbuildモードで読み込み | E-02 (nls.messages.json読み込み) | ○ |
| C-17 | 目標処理時間5分以内 | **根拠なし** | △ |
| C-18 | メモリ使用量上限1GB程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間、メモリ使用量）の具体的な根拠
  - 候補：CI実行ログ / パフォーマンステストレポート / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 1: 中リスク - パフォーマンス要件は経験則に基づく推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間、メモリ）の妥当性を実環境で確認
- [ ] CI/CDトリガーの説明がGitHub Actionsワークフローと一致しているか確認
- [ ] 除外パターン（excludeGlob）の説明が実際の動作と一致するか確認
