---
generated_at: 2026-01-27 12:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-test-node バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間2分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - npmスクリプト定義
- E-02: `test/unit/node/index.js` - Nodeテストエントリーポイント
- E-03: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | test-nodeはMochaを使用してテストを実行 | E-01, E-02 | ○ |
| C-02 | npmスクリプトとして定義されている | E-01 (`"test-node": "mocha test/unit/node/index.js --delay --ui=tdd --timeout=5000 --exit"`) | ○ |
| C-03 | デフォルトタイムアウトは5000ms | E-01 (--timeout=5000) | ○ |
| C-04 | TDDインターフェースを使用 | E-01, E-02 (--ui=tdd, ui: 'tdd') | ○ |
| C-05 | --buildオプションでout-buildを使用可能 | E-02 (args.build処理) | ○ |
| C-06 | Node.jsバージョンを検証する | E-02 (semver, requiredNodeVersion) | ○ |
| C-07 | remote/.npmrcからtargetバージョンを取得 | E-02 (`/remote/.npmrc`読み込み処理) | ○ |
| C-08 | browser/electron系テストは除外される | E-02 (excludeGlobs定義) | ○ |
| C-09 | nativeModules.test.jsは除外される | E-02 (excludeGlobs) | ○ |
| C-10 | storage.test.jsは除外される | E-02 (excludeGlobs) | ○ |
| C-11 | testing/test配下は除外される | E-02 (excludeGlobs) | ○ |
| C-12 | ESMモジュールをサポート | E-02 (import構文, baseUrl処理) | ○ |
| C-13 | グローバル変数_VSCODE_PRODUCT_JSONを設定 | E-02 (globalThis._VSCODE_PRODUCT_JSON) | ○ |
| C-14 | 予期せぬエラーを最終テストで検証 | E-02 (unexpectedErrors, Mocha.suite('Errors'...)) | ○ |
| C-15 | 失敗時は終了コード1を返す | E-02 (process.exit(failures ? 1 : 0)) | ○ |
| C-16 | 目標処理時間2分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：CI実行ログ / パフォーマンステストレポート / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 1: 中リスク - パフォーマンス要件は経験則に基づく推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性を実環境で確認
- [ ] 除外パターン（excludeGlobs）の説明が実際の動作と一致するか確認
- [ ] Node.jsバージョン要件がremote/.npmrcの内容と一致するか確認
