---
generated_at: 2026-01-27 12:44:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-test.sh/test.bat バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/test.sh` - Linux/macOS向けシェルスクリプト
- E-02: `scripts/test.bat` - Windows向けバッチファイル
- E-03: `test/unit/electron/index.js` - Electronテストエントリーポイント
- E-04: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOSでulimit -n 4096を実行 | E-01 (ulimit -n 4096) | ○ |
| C-02 | product.jsonからnameLong/applicationNameを取得 | E-01, E-02 (node -p処理) | ○ |
| C-03 | Electronバイナリパスは.build/electron配下 | E-01, E-02 (CODE変数定義) | ○ |
| C-04 | npm run electronでバイナリ準備 | E-01, E-02 | ○ |
| C-05 | ELECTRON_ENABLE_LOGGING=1を設定 | E-01, E-02 | ○ |
| C-06 | crash-reporter-directoryオプションをサポート | E-01, E-02, E-03 | ○ |
| C-07 | クラッシュダンプは.build/crashesに保存 | E-01, E-02 (VSCODECRASHDIR) | ○ |
| C-08 | test/unit/electron/index.jsを実行 | E-01, E-02 | ○ |
| C-09 | Windows版で終了コード255を0に変換 | E-02 (if %errorlevel% == 255 set errorlevel=0) | ○ |
| C-10 | Issue #28582に起因する問題 | E-02 (コメント) | ○ |
| C-11 | IPCでテスト結果を収集 | E-03 (IPCRunner class) | ○ |
| C-12 | BrowserWindowでテストを実行 | E-03 (new BrowserWindow) | ○ |
| C-13 | --devオプションでDevToolsを開く | E-03 (win.webContents.openDevTools()) | ○ |
| C-14 | crashReporter.startでクラッシュレポーター初期化 | E-03 | ○ |
| C-15 | --tfsオプションでJUnitレポート生成 | E-03 (MochaJUnitReporter) | ○ |
| C-16 | レンダラークラッシュを検出 | E-03 (render-process-gone event) | ○ |
| C-17 | --coverageオプションをサポート | E-03 (args.coverage) | ○ |
| C-18 | per-test-coverageでV8カバレッジ収集 | E-03 (startCoverage, snapshotCoverage) | ○ |
| C-19 | vscode-file://プロトコルを登録 | E-03 (registerFileProtocol) | ○ |
| C-20 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：CI実行ログ / パフォーマンステストレポート / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 1: 中リスク - パフォーマンス要件は経験則に基づく推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性を実環境で確認
- [ ] Windows版の終了コード処理がElectronバージョンアップで変更されていないか確認
- [ ] クラッシュレポーターの設定が最新のElectron APIと一致しているか確認
