---
generated_at: 2026-01-27 12:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：34-test-integration.sh/test-integration.bat バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間15分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/test-integration.sh` - Linux/macOS向けシェルスクリプト
- E-02: `scripts/test-integration.bat` - Windows向けバッチファイル
- E-03: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 一時ディレクトリをVSCODEUSERDATADIRとして作成 | E-01, E-02 (mktemp, %TEMP%) | ○ |
| C-02 | ログは.build/logs/integration-testsに出力 | E-01, E-02 (VSCODELOGSDIR) | ○ |
| C-03 | INTEGRATION_TEST_ELECTRON_PATHで実行バイナリを指定可能 | E-01, E-02 | ○ |
| C-04 | デフォルトはscripts/code.sh/code.batを使用 | E-01, E-02 | ○ |
| C-05 | Node.js統合テストは**.integrationTest.jsを実行 | E-01, E-02 (--runGlob) | ○ |
| C-06 | API_TESTS_EXTRA_ARGSに各種無効化オプションを含む | E-01, E-02 | ○ |
| C-07 | vscode-api-testsでAPIテストを実行 | E-01, E-02 | ○ |
| C-08 | フォルダとワークスペース両方のテストを実行 | E-01, E-02 (singlefolder-tests, workspace-tests) | ○ |
| C-09 | npm run test-extensionで拡張機能テストを実行 | E-01, E-02 | ○ |
| C-10 | vscode-colorize-testsをテスト | E-01, E-02 | ○ |
| C-11 | terminal-suggestをテスト | E-01, E-02 | ○ |
| C-12 | typescript-language-featuresをテスト | E-01, E-02 | ○ |
| C-13 | markdown-language-featuresをテスト | E-01, E-02 | ○ |
| C-14 | CSS/HTML言語サーバーテストをnode-electron.shで実行 | E-01 | ○ |
| C-15 | kill_app関数でプロセスをクリーンアップ | E-01, E-02 | ○ |
| C-16 | テスト終了後に一時ディレクトリを削除 | E-01 (rm -rf), E-02 (rmdir /s /q) | ○ |
| C-17 | Windows版はエラー発生時に即座に終了 | E-02 (if %errorlevel% neq 0 exit /b) | ○ |
| C-18 | 目標処理時間15分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：CI実行ログ / パフォーマンステストレポート / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - テスト対象拡張機能のリストはスクリプトで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性を実環境で確認
- [ ] テスト対象拡張機能のリストが最新かどうか確認
- [ ] API_TESTS_EXTRA_ARGSのオプションが最新のVSCode CLIと一致しているか確認
