---
generated_at: 2026-01-27 12:48:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：35-test-remote-integration.sh/test-remote-integration.bat バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間15分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/test-remote-integration.sh` - Linux/macOS向けシェルスクリプト
- E-02: `scripts/test-remote-integration.bat` - Windows向けバッチファイル
- E-03: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトのAUTHORITYはvscode-remote://test+test | E-01, E-02 | ○ |
| C-02 | REMOTE_VSCODE環境変数を設定 | E-01, E-02 | ○ |
| C-03 | TESTRESOLVER_DATA_FOLDERを一時ディレクトリに設定 | E-01, E-02 | ○ |
| C-04 | TESTRESOLVER_LOGS_FOLDERをサーバーログディレクトリに設定 | E-01, E-02 | ○ |
| C-05 | gulp nodeでリモートサーバー用Node.jsをダウンロード | E-01, E-02 (npm run gulp node) | ○ |
| C-06 | VSCODE_REMOTE_SERVER_PATHでサーバーパスを指定可能 | E-01, E-02 | ○ |
| C-07 | ビルド版ではTESTRESOLVER_INSTALL_BUILTIN_EXTENSIONを設定 | E-01, E-02 | ○ |
| C-08 | --folder-uriでリモートフォルダを指定 | E-01, E-02 | ○ |
| C-09 | --file-uriでリモートワークスペースを指定 | E-01, E-02 | ○ |
| C-10 | EXTRA_INTEGRATION_TEST_ARGUMENTSにProposed API有効化を含む | E-01, E-02 | ○ |
| C-11 | TypeScript/Markdown/Emmet/Git/Ipynb/Configテストを実行 | E-01, E-02 | ○ |
| C-12 | テスト終了後に一時ディレクトリを削除 | E-01, E-02 | ○ |
| C-13 | テストリゾルバーデータディレクトリも削除 | E-01, E-02 (rm -rf $TESTRESOLVER_DATA_FOLDER) | ○ |
| C-14 | 引数で外部からAUTHORITY/EXT_PATH/USERDATADIRを指定可能 | E-01, E-02 ($1, $2, $3 / %1 %2 %3) | ○ |
| C-15 | ログは.build/logs/integration-tests-remoteに出力 | E-01, E-02 (VSCODELOGSDIR) | ○ |
| C-16 | kill_app関数でプロセスをクリーンアップ | E-01, E-02 | ○ |
| C-17 | 目標処理時間15分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：CI実行ログ / パフォーマンステストレポート / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - リモート環境のセットアップ手順はスクリプトで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性を実環境で確認
- [ ] テストリゾルバーの動作が最新のVSCodeリモート開発機能と一致しているか確認
- [ ] Proposed APIの有効化オプションが最新かどうか確認
