---
generated_at: 2026-01-27 12:52:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：37-upload-sourcemaps.ts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間10分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/upload-sourcemaps.ts` - メインスクリプト
- E-02: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUILD_SOURCEVERSIONからcommitハッシュを取得 | E-01 (process.env['BUILD_SOURCEVERSION']) | ○ |
| C-02 | ClientAssertionCredentialで認証 | E-01 (new ClientAssertionCredential) | ○ |
| C-03 | AZURE_TENANT_ID/CLIENT_ID/ID_TOKENを使用 | E-01 | ○ |
| C-04 | out-vscode-minからクライアントソースマップを収集 | E-01 (src('out-vscode-min')) | ○ |
| C-05 | getProductionDependenciesでnode_modulesを取得 | E-01 | ○ |
| C-06 | .build/extensionsから拡張機能ソースマップを収集 | E-01 (vfs.src(['.build/extensions/**/*.js.map'])) | ○ |
| C-07 | .moduleignoreでフィルタリング | E-01 (util.cleanNodeModules) | ○ |
| C-08 | プラットフォーム固有の.moduleignoreも適用 | E-01 (.moduleignore.${process.platform}) | ○ |
| C-09 | パスにcore/プレフィックスを付加 | E-01 (f.path = `${f.base}/core/${f.relative}`) | ○ |
| C-10 | $webコンテナにアップロード | E-01 (container: '$web') | ○ |
| C-11 | sourcemaps/{commit}/配下にアップロード | E-01 (prefix: `sourcemaps/${commit}/`) | ○ |
| C-12 | gulp-azure-storageを使用 | E-01 (azure.upload) | ○ |
| C-13 | カスタムbase/mapsパラメータをサポート | E-01 (process.argv[2], process.argv[3]) | ○ |
| C-14 | エラー時はprocess.exit(1) | E-01 (.catch, process.exit(1)) | ○ |
| C-15 | "Uploading Sourcemap"ログを出力 | E-01 (console.log('Uploading Sourcemap')) | ○ |
| C-16 | 目標処理時間10分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：Azure Pipelines実行ログ / パフォーマンステストレポート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - Azure認証の流れはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性をCI実行ログで確認
- [ ] Azure認証に必要な環境変数がパイプラインで正しく設定されているか確認
- [ ] .moduleignoreの内容が最新のnode_modules構成と一致しているか確認
