---
generated_at: 2026-01-27 12:54:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：38-upload-nlsmetadata.ts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/upload-nlsmetadata.ts` - メインスクリプト
- E-02: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUILD_SOURCEVERSIONからcommitハッシュを取得 | E-01 (process.env['BUILD_SOURCEVERSION']) | ○ |
| C-02 | ClientAssertionCredentialで認証 | E-01 (new ClientAssertionCredential) | ○ |
| C-03 | nls.keys.jsonとnls.messages.jsonをマージ | E-01 (gulp-merge-json) | ○ |
| C-04 | vscode.json形式で統合 | E-01 (fileName: 'vscode.json') | ○ |
| C-05 | 拡張機能からnls.metadata.json収集 | E-01 (vfs.src('.build/extensions/**/nls.metadata.json')) | ○ |
| C-06 | package.nls.jsonも収集 | E-01 (vfs.src('.build/extensions/**/package.nls.json')) | ○ |
| C-07 | publisher.name形式でキーを生成 | E-01 (manifestJson.publisher + '.' + manifestJson.name) | ○ |
| C-08 | package.nls.jsonは"package"キーで格納 | E-01 (messages: { package: ... }) | ○ |
| C-09 | combined.nls.metadata.jsonを生成 | E-01 (fileName: 'combined.nls.metadata.json') | ○ |
| C-10 | gzip圧縮を適用 | E-01 (gzip({ append: false })) | ○ |
| C-11 | ./nlsMetadata/にローカル出力 | E-01 (vfs.dest('./nlsMetadata')) | ○ |
| C-12 | ##vso[artifact.upload]でアーティファクト登録 | E-01 (console.log(`##vso[artifact.upload...`)) | ○ |
| C-13 | $webコンテナにアップロード | E-01 (container: '$web') | ○ |
| C-14 | nlsmetadata/{commit}/配下にアップロード | E-01 (prefix: `nlsmetadata/${commit}/`) | ○ |
| C-15 | Content-Encoding: gzipを設定 | E-01 (contentEncoding: 'gzip') | ○ |
| C-16 | Cache-Control: max-age=31536000を設定 | E-01 (cacheControl: 'max-age=31536000, public') | ○ |
| C-17 | nls.messages.jsもアップロード | E-01 (vfs.src('out-build/nls.messages.js')) | ○ |
| C-18 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：Azure Pipelines実行ログ / パフォーマンステストレポート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - NLSメタデータの構造はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性をCI実行ログで確認
- [ ] NLSメタデータの形式が言語パック作成に適しているか確認
- [ ] gzip圧縮とCache-Controlの設定がCDN配信に適しているか確認
