---
generated_at: 2026-01-27 12:56:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：39-upload-cdn.ts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間15分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/upload-cdn.ts` - メインスクリプト
- E-02: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUILD_SOURCEVERSIONからcommitハッシュを取得 | E-01 (process.env['BUILD_SOURCEVERSION']) | ○ |
| C-02 | VSCODE_QUALITYから品質レベルを取得 | E-01 (process.env.VSCODE_QUALITY) | ○ |
| C-03 | ClientAssertionCredentialで認証 | E-01 (new ClientAssertionCredential) | ○ |
| C-04 | ../vscode-webから全アセットを収集 | E-01 (vfs.src('**', { cwd: '../vscode-web' })) | ○ |
| C-05 | ディレクトリを除外 | E-01 (filter(f => !f.isDirectory())) | ○ |
| C-06 | MimeTypesToCompressで圧縮対象を判定 | E-01 (MimeTypesToCompress.has(mime.lookup(f.path))) | ○ |
| C-07 | application/typescriptを.tsにマッピング | E-01 (mime.define) | ○ |
| C-08 | application/jsonを.code-snippetsにマッピング | E-01 (mime.define) | ○ |
| C-09 | 圧縮対象はgzip圧縮してアップロード | E-01 (gzip({ append: false })) | ○ |
| C-10 | Content-Encoding: gzipを設定 | E-01 (contentEncoding: compressed ? 'gzip' : undefined) | ○ |
| C-11 | Cache-Control: max-age=31536000を設定 | E-01 (cacheControl: 'max-age=31536000, public') | ○ |
| C-12 | {quality}/{commit}/配下にアップロード | E-01 (prefix: `${process.env.VSCODE_QUALITY}/${commit}/`) | ○ |
| C-13 | files.txtを生成 | E-01 (new Vinyl({ path: 'files.txt' })) | ○ |
| C-14 | アップロードしたファイル数をログ出力 | E-01 (console.log(`Uploading: files.txt (${files.length} files)`)) | ○ |
| C-15 | 圧縮/非圧縮を並列でアップロード | E-01 (es.merge(compressed, uncompressed)) | ○ |
| C-16 | $webコンテナにアップロード | E-01 (container: '$web') | ○ |
| C-17 | 目標処理時間15分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：Azure Pipelines実行ログ / パフォーマンステストレポート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - 圧縮対象MIMEタイプのリストはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性をCI実行ログで確認
- [ ] MimeTypesToCompressのリストがAzure CDNの設定と一致しているか確認
- [ ] Cache-Controlの設定がCDN配信ポリシーに適しているか確認
