---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-product-release

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/product-release.yml` (L1-42)
- E-02: `build/azure-pipelines/product-build.yml` (L492-519)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L5)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VSCODE_RELEASEパラメータを受け取る | E-01 L2-3 (parameters) | ○ |
| C-02 | common/checkout.ymlでチェックアウト | E-01 L6 (template) | ○ |
| C-03 | .nvmrcからNode.jsバージョン取得 | E-01 L8-10 (NodeTool@0) | ○ |
| C-04 | AzureCLI@2でサービスプリンシパル情報取得 | E-01 L12-23 (AzureCLI@2) | ○ |
| C-05 | AZURE_TENANT_ID, AZURE_CLIENT_ID, AZURE_ID_TOKEN変数を設定 | E-01 L19-22 (inlineScript) | ○ |
| C-06 | build/でnpm ci実行 | E-01 L25-27 (npm ci) | ○ |
| C-07 | getPublishAuthTokens.tsで認証トークン取得 | E-01 L29-36 (getPublishAuthTokens.ts) | ○ |
| C-08 | releaseBuild.tsでリリース実行 | E-01 L38-41 (releaseBuild.ts) | ○ |
| C-09 | VSCODE_RELEASEパラメータをreleaseBuild.tsに渡す | E-01 L38 (${{ parameters.VSCODE_RELEASE }}) | ○ |
| C-10 | Releaseステージの実行条件 | E-02 L492 (条件分岐) | ○ |
| C-11 | PublishとApproveReleaseに依存 | E-02 L506-508 (dependsOn) | ○ |
| C-12 | Linuxエージェントで実行 | E-02 L509-511 (pool: 1es-ubuntu-22.04-x64) | ○ |
| C-13 | VSCODE_PRIVATE_BUILD=falseが条件 | E-02 L492 (eq(variables['VSCODE_PRIVATE_BUILD'], false)) | ○ |
| C-14 | ApproveReleaseステージで承認プロセス | E-02 L493-504 (ApproveRelease stage) | ○ |
| C-15 | VSCodePeerApproval変数グループ使用 | E-02 L502 (group: VSCodePeerApproval) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がproduct-release.ymlとproduct-build.ymlから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VSCodePeerApproval変数グループのメンバーと承認ルールが適切か確認
- [ ] VSCODE_PRIVATE_BUILD条件により、フォークからのリリースが防止されているか確認
- [ ] releaseBuild.tsの処理内容がリリース要件と一致するか確認
