---
generated_at: 2026-01-27 12:58:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：40-codesign.ts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30分**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/common/codesign.ts` - 共通署名ユーティリティ
- E-02: `build/azure-pipelines/win32/codesign.ts` - Windows署名スクリプト
- E-03: `build/azure-pipelines/darwin/codesign.ts` - macOS署名スクリプト
- E-04: `build/azure-pipelines/linux/codesign.ts` - Linux署名スクリプト
- E-05: `バッチ一覧.csv` - バッチ概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | spawnCodesignProcessでESRP CLIを呼び出し | E-01 (`node build/azure-pipelines/common/sign.ts`) | ○ |
| C-02 | printBanner関数で視覚的区切りを出力 | E-01 (console.log('#'.repeat(75))) | ○ |
| C-03 | streamProcessOutputAndCheckResultで結果検証 | E-01 (result.ok確認) | ○ |
| C-04 | Windows: DLL/EXE/Node署名 | E-02 ('sign-windows', '*.dll,*.exe,*.node') | ○ |
| C-05 | Windows: PowerShell署名 | E-02 ('sign-windows-appx', '*.ps1') | ○ |
| C-06 | Windows: APPX署名（exploration以外） | E-02 (process.env['VSCODE_QUALITY'] !== 'exploration') | ○ |
| C-07 | Windows: 署名タスクを並列起動 | E-02 (const codesignTask1, codesignTask2, codesignTask3) | ○ |
| C-08 | Windows: 7z.exeでZIPアーカイブ作成 | E-02 (7z.exe a -tzip) | ○ |
| C-09 | Windows: BUILT_CLIENTでクライアントパッケージ作成 | E-02 (process.env['BUILT_CLIENT']) | ○ |
| C-10 | Windows: BUILT_SERVERでサーバーパッケージ作成 | E-02 (process.env['BUILT_SERVER']) | ○ |
| C-11 | Windows: BUILT_WEBでWebサーバーパッケージ作成 | E-02 (process.env['BUILT_WEB']) | ○ |
| C-12 | Windows: Gulpタスクでセットアップ作成 | E-02 (npm exec -- npm-run-all2 -lp "gulp vscode-win32-{arch}-system-setup") | ○ |
| C-13 | Windows: CodeSignSummary*.mdを除外 | E-02 ("-xr!CodeSignSummary*.md") | ○ |
| C-14 | macOS: sign-darwinで署名 | E-03 ('sign-darwin', folder, glob) | ○ |
| C-15 | macOS: notarize-darwinで公証 | E-03 ('notarize-darwin', folder, glob) | ○ |
| C-16 | macOS: PIPELINE_WORKSPACEからパス取得 | E-03 (e('PIPELINE_WORKSPACE')) | ○ |
| C-17 | macOS: VSCode-darwin-{arch}.zipを対象 | E-03 (glob = `VSCode-darwin-${arch}.zip`) | ○ |
| C-18 | Linux: DEBパッケージ署名（PGP） | E-04 ('sign-pgp', '.build/linux/deb', '*.deb') | ○ |
| C-19 | Linux: RPMパッケージ署名（PGP） | E-04 ('sign-pgp', '.build/linux/rpm', '*.rpm') | ○ |
| C-20 | Linux: 署名タスクを並列起動 | E-04 (const codesignTask1, codesignTask2) | ○ |
| C-21 | エラー時はprocess.exit(1) | E-02, E-03, E-04 (.then, .catch) | ○ |
| C-22 | 目標処理時間30分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間）の具体的な根拠
  - 候補：Azure Pipelines実行ログ / ESRPサービスのSLA

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 署名処理の流れは全てソースコードで検証済み
- 1: 中リスク - ESRPサービスの詳細は外部依存のため確認困難

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（処理時間）の妥当性をCI実行ログで確認
- [ ] ESRPサービスの認証設定が正しく構成されているか確認
- [ ] 各プラットフォームの署名対象ファイルパターンが最新か確認
- [ ] Apple公証のタイムアウト設定が適切か確認
