---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-product-build-win32.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間の根拠**：timeoutInMinutesからの推定
  2. **リトライ回数**：retryCountOnTaskFailureの値確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/win32/product-build-win32.yml`
- E-02: `build/azure-pipelines/win32/steps/product-build-win32-compile.yml`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-04: `build/azure-pipelines/common/checkout.yml`
- E-05: `build/azure-pipelines/distro/download-distro.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows x64/arm64向けビルドパイプライン | E-01 L19-20 | ○ |
| C-02 | タイムアウト90分 | E-01 L21 | ○ |
| C-03 | VSCODE_ARCHパラメータ必須 | E-01 L2-3 | ○ |
| C-04 | VSCODE_CIBUILDパラメータ必須 | E-01 L4-5 | ○ |
| C-05 | VSCODE_QUALITYパラメータ必須 | E-01 L6-7 | ○ |
| C-06 | テストパラメータのデフォルト値false | E-01 L8-16 | ○ |
| C-07 | system-setup成果物出力 | E-01 L50-55 | ○ |
| C-08 | user-setup成果物出力 | E-01 L56-62 | ○ |
| C-09 | archive成果物出力 | E-01 L63-69 | ○ |
| C-10 | server成果物出力 | E-01 L70-76 | ○ |
| C-11 | web成果物出力 | E-01 L77-83 | ○ |
| C-12 | product-build-win32-compileテンプレート呼び出し | E-01 L88-95 | ○ |
| C-13 | Compilation artifactダウンロード | E-02 L40-44 | ○ |
| C-14 | node_modulesキャッシュ機能 | E-02 L61-69 | ○ |
| C-15 | npm ciリトライ5回 | E-02 L100 | ○ |
| C-16 | ESRPコード署名実行 | E-02 L207-217 | ○ |
| C-17 | クライアントビルドコマンド | E-02 L133-142 | ○ |
| C-18 | サーバービルドコマンド | E-02 L161-170 | ○ |
| C-19 | Webサーバービルドコマンド | E-02 L172-181 | ○ |
| C-20 | CLIダウンロード・統合 | E-02 L183-201 | ○ |
| C-21 | Group Policy生成（非CI） | E-02 L122-127 | ○ |
| C-22 | APPX準備（非CI） | E-02 L148-159 | ○ |
| C-23 | SDL抑制ファイル設定 | E-01 L84-86 | ○ |
| C-24 | 目標処理時間90分以内 | **推定値** | △ |
| C-25 | パイプライントリガー説明 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間はtimeoutInMinutesから推定したもので、実績データに基づく検証が必要
  - 候補：パイプライン実行履歴 / パフォーマンス計測結果
- トリガー条件の詳細は上位パイプライン（product-build.yml）の確認が必要
  - 候補：product-build.yml / Azure DevOps設定

## 5) リスクフラグ（レビュー観点）
- 0: ESRP署名の詳細オプション - ソースコード内で動的に決定される部分あり
- 0: 成果物命名規則 - バージョン番号の取得ロジックはpackage.jsonから動的取得

## 6) レビュアーチェックリスト（最小）
- [ ] VSCODE_QUALITYパラメータの有効値（stable/insider/exploration）が最新か確認
- [ ] ESRPコード署名の接続先設定が運用環境と一致するか確認
- [ ] timeoutInMinutes: 90が実運用で十分か確認
- [ ] SDLセキュリティ抑制ファイルのパスが正しいか確認
