---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：42-product-build-linux.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **armhfのGLIBCXXバージョン**：3.4.26の根拠確認
  2. **パイプライントリガー条件**：上位パイプラインの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/linux/product-build-linux.yml`
- E-02: `build/azure-pipelines/linux/steps/product-build-linux-compile.yml`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-04: `build/azure-pipelines/linux/verify-glibc-requirements.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linux x64/arm64/armhf向けビルド | E-01 L24-25 | ○ |
| C-02 | タイムアウト90分 | E-01 L26 | ○ |
| C-03 | NPM_ARCHパラメータ必須 | E-01 L2-3 | ○ |
| C-04 | VSCODE_ARCHパラメータ必須 | E-01 L4-5 | ○ |
| C-05 | VSCODE_BUILD_LINUX_SNAPデフォルトfalse | E-01 L10-12 | ○ |
| C-06 | client archive成果物出力 | E-01 L60-66 | ○ |
| C-07 | server archive成果物出力 | E-01 L67-73 | ○ |
| C-08 | web server archive成果物出力 | E-01 L74-80 | ○ |
| C-09 | debパッケージ成果物出力 | E-01 L81-87 | ○ |
| C-10 | rpmパッケージ成果物出力 | E-01 L88-94 | ○ |
| C-11 | snapパッケージ出力（条件付き） | E-01 L95-102 | ○ |
| C-12 | BinSkimセキュリティスキャン設定 | E-01 L33-35 | ○ |
| C-13 | システムサービスセットアップ（Xvfb等） | E-02 L47-62 | ○ |
| C-14 | VSCode sysrootダウンロード | E-02 L117-128 | ○ |
| C-15 | GLIBC 2.28互換性検証 | E-02 L238-250 | ○ |
| C-16 | GLIBCXX 3.4.25（x64/arm64） | E-02 L242-244 | ○ |
| C-17 | GLIBCXX 3.4.26（armhf） | E-02 L256-258 | △ |
| C-18 | debパッケージビルド | E-02 L273-286 | ○ |
| C-19 | xz圧縮検証 | E-02 L279-283 | ○ |
| C-20 | rpmパッケージビルド | E-02 L305-312 | ○ |
| C-21 | snapビルド（Docker使用） | E-02 L323-342 | ○ |
| C-22 | CLI統合処理 | E-02 L189-203 | ○ |
| C-23 | ESRP署名（deb/rpm） | E-02 L368-372 | ○ |
| C-24 | chrome-sandbox SUIDビット除去 | E-02 L411-414 | ○ |
| C-25 | npm ciリトライ5回 | E-02 L98-108 | ○ |
| C-26 | sysroot prefix設定 | E-02 L124 | ○ |
| C-27 | 目標処理時間90分以内 | **推定値** | △ |
| C-28 | パイプライントリガー説明 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- armhfのGLIBCXXバージョン3.4.26の詳細な理由（コメントなし）
  - 候補：GCC バージョン要件 / ARM向けビルド要件
- トリガー条件の詳細は上位パイプラインの確認が必要
  - 候補：product-build.yml / Azure DevOps設定

## 5) リスクフラグ（レビュー観点）
- 0: sysroot バージョン - glibc-2.28-gcc-8.5.0とglibc-2.28-gcc-10.5.0の使い分け
- 0: Docker イメージ依存 - vscodehub.azurecr.io/vscode-linux-build-agent:snapcraft-x64

## 6) レビュアーチェックリスト（最小）
- [ ] GLIBC/GLIBCXXバージョン要件が最新のLinuxディストリビューションサポート方針と一致するか確認
- [ ] sysrootのGCCバージョン（8.5.0 vs 10.5.0）の使い分けが正しいか確認
- [ ] snapビルド用Dockerイメージのバージョンが最新か確認
- [ ] debパッケージのxz圧縮検証ロジックが正しいか確認
