---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：43-product-build-darwin.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **Keychainパスワードのセキュリティ**：一時的な使用だが確認推奨
  2. **GYP_DEFINESの設定理由**：コメントはあるが詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/darwin/product-build-darwin.yml`
- E-02: `build/azure-pipelines/darwin/steps/product-build-darwin-compile.yml`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-04: `build/darwin/sign.ts`
- E-05: `build/darwin/verify-macho.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOS x64/arm64向けビルド | E-01 L17-18 | ○ |
| C-02 | タイムアウト90分 | E-01 L19 | ○ |
| C-03 | VSCODE_ARCHパラメータ必須 | E-01 L2-3 | ○ |
| C-04 | VSCODE_CIBUILDパラメータ必須 | E-01 L4-5 | ○ |
| C-05 | client archive成果物出力 | E-01 L48-57 | ○ |
| C-06 | server archive成果物出力 | E-01 L58-64 | ○ |
| C-07 | web archive成果物出力 | E-01 L65-71 | ○ |
| C-08 | Key Vaultシークレット取得（証明書含む） | E-02 L27-31 | ○ |
| C-09 | クライアントビルドコマンド | E-02 L125-131 | ○ |
| C-10 | サーバービルドコマンド | E-02 L133-143 | ○ |
| C-11 | Webサーバービルドコマンド | E-02 L145-155 | ○ |
| C-12 | CLI統合処理 | E-02 L157-175 | ○ |
| C-13 | Mach-Oアーキテクチャ検証 | E-02 L177-183 | ○ |
| C-14 | 未署名アーカイブ公開 | E-02 L185-207 | ○ |
| C-15 | Hardened Entitlements設定 | E-02 L215-225 | ○ |
| C-16 | Keychain作成・証明書インポート | E-02 L216-223 | ○ |
| C-17 | ESRP署名・ノータリゼーション | E-02 L260-264 | ○ |
| C-18 | 署名検証（codesign -dv） | E-02 L281-288 | ○ |
| C-19 | x64用命名（VSCode-darwin.zip） | E-02 L294-296 | ○ |
| C-20 | arm64用命名（VSCode-darwin-arm64.zip） | E-02 L298 | ○ |
| C-21 | GYP_DEFINES設定 | E-02 L96-99 | ○ |
| C-22 | npm ciリトライ5回 | E-02 L82-89 | ○ |
| C-23 | setuptools pip install | E-02 L81 | ○ |
| C-24 | デフォルト設定エクスポートテスト | E-02 L287 | ○ |
| C-25 | 目標処理時間90分以内 | **推定値** | △ |
| C-26 | パイプライントリガー説明 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Keychainパスワード"pwd"のセキュリティポリシー
  - 候補：Azure Pipelines一時エージェント設計 / セキュリティガイドライン
- トリガー条件の詳細は上位パイプラインの確認が必要
  - 候補：product-build.yml / Azure DevOps設定

## 5) リスクフラグ（レビュー観点）
- 0: Keychain操作 - 一時ディレクトリで実行、ジョブ終了時に破棄
- 0: 証明書セキュリティ - Key Vaultから取得し、base64デコードして使用

## 6) レビュアーチェックリスト（最小）
- [ ] macos-developer-certificate、macos-developer-certificate-keyの有効期限確認
- [ ] Hardened Runtime entitlementsの設定が最新のmacOS要件を満たすか確認
- [ ] Apple Developer IDの有効期限とノータリゼーション設定の確認
- [ ] GYP_DEFINES設定がKerberos問題の解決に有効か確認
