---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：44-product-build-alpine.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ターゲット名の命名規則**：linux-alpine vs alpine-arm64の違い
  2. **NodeJS MUSLバージョン取得ロジック**：動的取得部分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/alpine/product-build-alpine.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `remote/.npmrc`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Alpine x64/arm64向けビルド | E-01 L6-7 | ○ |
| C-02 | タイムアウト30分 | E-01 L8 | ○ |
| C-03 | プール: 1es-ubuntu-22.04-x64 | E-01 L9-11 | ○ |
| C-04 | x64向けサーバーアーカイブ（レガシー名） | E-01 L18-26 | ○ |
| C-05 | x64向けWebアーカイブ（レガシー名） | E-01 L27-34 | ○ |
| C-06 | arm64向けサーバーアーカイブ | E-01 L35-42 | ○ |
| C-07 | arm64向けWebアーカイブ | E-01 L43-49 | ○ |
| C-08 | Dockerイメージプル | E-01 L110-118 | ○ |
| C-09 | libkrb5-devインストール | E-01 L120-122 | ○ |
| C-10 | NodeJS MUSLダウンロード | E-01 L124-135 | ○ |
| C-11 | npm ciリトライ5回 | E-01 L137-157 | ○ |
| C-12 | VSCODE_HOST_MOUNT設定 | E-01 L154 | ○ |
| C-13 | サーバービルドコマンド | E-01 L176-189 | ○ |
| C-14 | Webサーバービルドコマンド | E-01 L191-204 | ○ |
| C-15 | ターゲット名の条件分岐（x64=linux-alpine） | E-01 L178 | ○ |
| C-16 | ターゲット名の条件分岐（arm64=alpine-arm64） | E-01 L178 | ○ |
| C-17 | tarアーカイブ所有者設定（root:root） | E-01 L184, L200 | ○ |
| C-18 | node_modulesキャッシュキー | E-01 L80-81 | ○ |
| C-19 | 目標処理時間30分以内 | **推定値** | △ |
| C-20 | 命名規則の理由（TODO@joaomoreno） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- linux-alpine vs alpine-arm64 命名規則の統一計画
  - 候補：TODO@joaomorenoのissue / 将来のリファクタリング計画
- NodeJS MUSLバージョンの決定ロジック（remote/.npmrcから動的取得）
  - 候補：remote/.npmrcファイルの内容 / microsoft/vscode-nodeリリース

## 5) リスクフラグ（レビュー観点）
- 0: ターゲット命名の不整合 - x64とarm64で異なる命名パターン
- 0: NodeJS MUSL取得 - GitHub API依存、レート制限の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] vscode-linux-build-agent:alpine-$(VSCODE_ARCH) Dockerイメージのバージョンが最新か確認
- [ ] microsoft/vscode-nodeリポジトリのNodeJSバージョンがremote/.npmrcと一致するか確認
- [ ] VSCODE_HOST_MOUNTパスがAzure Pipelines環境と一致するか確認
- [ ] ターゲット命名（linux-alpine/alpine-arm64）が他のパイプラインと整合性があるか確認
