---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：45-product-build-web.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **CDNアップロードの部分完了リスク**：ロールバック手順確認
  2. **Azure認証方式**：ワークロードIDフェデレーションの設定確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/web/product-build-web.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/upload-cdn.ts`
- E-04: `build/azure-pipelines/upload-sourcemaps.ts`
- E-05: `build/azure-pipelines/upload-nlsmetadata.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Webジョブ定義 | E-01 L1-3 | ○ |
| C-02 | タイムアウト30分 | E-01 L4 | ○ |
| C-03 | プール: 1es-ubuntu-22.04-x64 | E-01 L5-7 | ○ |
| C-04 | VSCODE_ARCH固定x64 | E-01 L8-9 | ○ |
| C-05 | Web archive成果物出力 | E-01 L11-18 | ○ |
| C-06 | SBOM設定 | E-01 L16-18 | ○ |
| C-07 | npm ciリトライ5回 | E-01 L86-96 | ○ |
| C-08 | システムサービスセットアップ（libkrb5-dev） | E-01 L79-84 | ○ |
| C-09 | Webビルドコマンド（vscode-web-min-ci） | E-01 L121-123 | ○ |
| C-10 | Azure認証情報取得 | E-01 L132-142 | ○ |
| C-11 | CDNアップロード実行 | E-01 L144-150 | ○ |
| C-12 | AZURE_STORAGE_ACCOUNT=vscodeweb | E-01 L146 | ○ |
| C-13 | ソースマップアップロード | E-01 L152-159 | ○ |
| C-14 | ソースマップ対象ファイル | E-01 L159 | ○ |
| C-15 | NLSメタデータアップロード | E-01 L161-168 | ○ |
| C-16 | tarアーカイブ作成 | E-01 L124-127 | ○ |
| C-17 | 所有者設定（root:root） | E-01 L126 | ○ |
| C-18 | Azure CLIタスク使用 | E-01 L132-142 | ○ |
| C-19 | ワークロードIDフェデレーション（OIDC） | E-01 L138 | ○ |
| C-20 | node_modulesキャッシュキー（web） | E-01 L49 | ○ |
| C-21 | CDNアップロード部分完了リスク | **推定** | △ |
| C-22 | 目標処理時間30分以内 | **推定値** | △ |

## 4) 不足情報（Unknown / Missing）
- CDNアップロード失敗時のロールバック手順
  - 候補：運用手順書 / Azure Storage設定
- ワークロードIDフェデレーションの詳細設定
  - 候補：Azure DevOpsサービス接続設定 / Azure AD設定

## 5) リスクフラグ（レビュー観点）
- 1: CDN部分アップロード - 失敗時に古いファイルと新しいファイルが混在する可能性
- 0: 認証トークン漏洩 - AZURE_ID_TOKENは環境変数として渡されるがログには出力されない

## 6) レビュアーチェックリスト（最小）
- [ ] vscodeweb Azure Storageアカウントのアクセス権設定が正しいか確認
- [ ] サービスプリンシパルの有効期限が十分にあるか確認
- [ ] CDNキャッシュパージの設定が適切か確認
- [ ] ソースマップアップロード対象ファイルパスが最新か確認
