---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：46-product-build-win32-cli.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **CETCOMPATフラグのarm64対応**：/CETCOMPAT:NOの理由確認
  2. **OpenSSLバージョン固定**：@0.0.11の最新性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/win32/product-build-win32-cli.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/cli/cli-compile.yml`
- E-04: `build/azure-pipelines/cli/cli-apply-patches.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows CLI x64/arm64向けビルド | E-01 L11-12 | ○ |
| C-02 | タイムアウト30分 | E-01 L16 | ○ |
| C-03 | プール: 1es-windows-2022-x64 | E-01 L13-15 | ○ |
| C-04 | VSCODE_CHECK_ONLYデフォルトfalse | E-01 L4-6 | ○ |
| C-05 | 未署名CLIアーティファクト出力 | E-01 L20-27 | ○ |
| C-06 | SBOMは無効 | E-01 L26-27 | ○ |
| C-07 | CLIパッチ適用テンプレート | E-01 L37 | ○ |
| C-08 | OpenSSLダウンロード（@0.0.11） | E-01 L39-45 | ○ |
| C-09 | OpenSSL展開処理 | E-01 L47-50 | ○ |
| C-10 | Rustインストールテンプレート | E-01 L52-59 | ○ |
| C-11 | x64ターゲット（x86_64-pc-windows-msvc） | E-01 L56-57 | ○ |
| C-12 | arm64ターゲット（aarch64-pc-windows-msvc） | E-01 L58-59 | ○ |
| C-13 | cli-compileテンプレート呼び出し | E-01 L61-77 | ○ |
| C-14 | 静的CRTリンクフラグ | E-01 L74 | ○ |
| C-15 | Control Flow Guardフラグ | E-01 L74 | ○ |
| C-16 | CETフラグ（x64） | E-01 L74 | ○ |
| C-17 | CETフラグ（arm64: /CETCOMPAT:NO） | E-01 L76 | ○ |
| C-18 | Spectreフラグ | E-01 L77 | ○ |
| C-19 | CETarm64無効の理由 | **根拠なし** | △ |
| C-20 | 目標処理時間30分以内 | **推定値** | △ |

## 4) 不足情報（Unknown / Missing）
- arm64でCETが無効（/CETCOMPAT:NO）になっている理由
  - 候補：Windows ARM64プラットフォーム制限 / Rustコンパイラ制限
- OpenSSL @0.0.11バージョンの選定理由と最新性
  - 候補：セキュリティアドバイザリ / 依存関係要件

## 5) リスクフラグ（レビュー観点）
- 0: OpenSSLバージョン固定 - セキュリティアップデートが必要な場合の対応
- 0: セキュリティフラグ依存 - コンパイラバージョンによるフラグサポート差異

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSL @0.0.11に既知の脆弱性がないか確認
- [ ] Rustツールチェーンバージョンがセキュリティフラグをサポートするか確認
- [ ] arm64のCET無効化がセキュリティ要件を満たすか確認
- [ ] Monaco/openssl-prebuiltフィードへのアクセス権設定が正しいか確認
